/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "HiveChat.h"
#include "HiveConfiguration.h"
#include "Types/HiveChatTypes.h"
#include "HiveResultAPI.h"

#include "UObject/Object.h"
#include "ChatTestView.generated.h"

UCLASS(BlueprintType)
class HIVESDKV4TESTER_API UChatTestView : public UObject
{
    GENERATED_BODY()
    
public:
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void Connect();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void Reconnect();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void Disconnect();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void IsConnected();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void GetChannelInfo(FString channelId);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void GetChannelMembers(FString channelId);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void DeleteChannel(FString channelId);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void EnterChannel(FString channelId, FString password);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void ExitChannel(FString channelId);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void GetChannelsByUser();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void GetBlockMembers();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void BlockMember(FString blockPlayerIdStr);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void UnblockMember(FString blockPlayerIdStr);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void SendMessageToChannelWithParams();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void SendMessageToPlayerWithParams();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void CreateChannelWithParams();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void GetChannelsWithParams();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void QueryChannelMessages(FString channelId);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void SetChannelTranslationEnabled(FString channelId, bool enabled);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void TranslateMessage();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void AddReactionWithParams(FString channelId);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void RemoveReactionWithParams(FString channelId);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    void QueryChannelWithParams(FString channelId);

private:
    bool bSetListener = false;
    
    // 리스너 객체들을 멤버 변수로 저장
    FHiveChannelListener* ChannelListenerInstance = nullptr;
    FHiveConnectionListener* ConnectionListenerInstance = nullptr;
    FHiveUserListener* UserListenerInstance = nullptr;
    FHiveCustomDataListener* CustomDataListenerInstance = nullptr;

    void AddLogString(FString str);
    void AddListeners();
    
    // Helper functions
    EHiveChannelType FStringToChannelType(const FString& TypeStr);
    FString GetChannelTypeString(EHiveChannelType Type);
    FString GetSortTypeString(EHiveSortType Type);
};
