/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#if PLATFORM_IOS
#include "CPP/HIVE_CPP.h"
#else
#include "HIVE_CPP.h"
#endif
using namespace hive;

#include "HiveConfiguration.h"
#include "HiveLogger.h"

#include "UObject/Object.h"
#include "ConfigurationDialog.generated.h"

/**
 * 
 */

UCLASS(BlueprintType)
//UCLASS(EditInlineNew, Meta = (BlueprintSpawnableComponent))
class HIVESDKV4TESTER_API UConfigurationDialog : public UObject
{
	GENERATED_BODY()
	
public:
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4/Objects")
    static UConfigurationDialog * ConstructNewObject();
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TArray<FString> LanuguageList;

    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrAppId;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrZone;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrLanguage;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrHiveTheme;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrHiveOrientation;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    bool mBuseLog;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrServerID;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    bool mUseAgeGate;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrHiveCommunityUrl;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrLogType;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrChannel;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrMarket;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    bool mUseHercules;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mStrCertificationKey;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    bool mCrossPromotionBannerShowing;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    bool mUsePrivateBrowsingForAuth;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    bool mEnableGameController;

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    FString SDKGetVersion();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    FString GetAdvertisingID();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void SaveConfig();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void ResetConfig();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    FString ViewConfig();

	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
	void SetPermissionViewOn(bool viewOn);

	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
	FString GetPermissionViewData();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    FString GetHiveTimeZone();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    FString GetHiveCountry();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    FString GetChannel();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void SetChannel(FString channel);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Config")
    void SetMarket(FString market);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void SetHiveTheme(FString hiveThemeType);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void SetHiveOrientation(FString hiveOrientation);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void SetHiveCommunityUrl(FString url);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void SetLogFilter(FString strLogType);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void SetCertificationKey(FString certificationKey);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void SetCrossPromotionBannerShowing(bool showing);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void HIVEConfigurationGetMetaData(FString key, FString forceReload);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void GetAgeGateU16Agree();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void GetLegalGuardianConsentMode();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void GetCrossPromotionBannerShowing();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Config")
    void SetChatConnectionTimeout(FString Seconds);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Config")
    void GetChatConnectionTimeout();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Config")
    FString GetGameLanguage();
    
private:
    std::vector<std::string> split(const std::string& input, char delimiter);
    // 23.0.0 버전 정보 반환 로직이 수정됨에 따라 전달되는 버전 정보가 너무 많아, 일부 잘라서 노출이 필요
    std::string getAndroidExternalLibraryNames(const std::vector<std::string>& input);
    
};
