//
//  ConfigurationsKeyView.cpp
//  HIVESDKV4Tester
//
//  Created by disker on 2021/07/08.
//  Copyright © 2021 Epic Games, Inc. All rights reserved.
//

#include "ConfigurationsKeyView.h"
#include "HIVESDKV4Tester.h"
#include "HIVESDKV4TesterGameMode.h"


void UConfigurationsKeyView::SetConfigurations(FString hiveConfigType, FString value)
{
    EHiveConfigType Type = EHiveConfigType::GoogleServerClientId;
    if(hiveConfigType.Equals(TEXT("googlePlayGamesServerClientId")))
    {
        Type = EHiveConfigType::GooglePlayGamesServerClientId;
    }
    else if(hiveConfigType.Equals(TEXT("wechatSecret")))
    {
        Type = EHiveConfigType::WechatSecret;
    }
    else if(hiveConfigType.Equals(TEXT("wechatPaymentKey")))
    {
        Type = EHiveConfigType::WechatPaymentKey;
    }
    else if(hiveConfigType.Equals(TEXT("adjustKey")))
    {
        Type = EHiveConfigType::AdjustKey;
    }
    else if(hiveConfigType.Equals(TEXT("singularKey")))
    {
        Type = EHiveConfigType::SingularKey;
    }
    else if(hiveConfigType.Equals(TEXT("appsflyerKey")))
    {
        Type = EHiveConfigType::AppsflyerKey;
    }
    else if(hiveConfigType.Equals(TEXT("airbridgeKey")))
    {
        Type = EHiveConfigType::AirbridgeKey;
    }
    else if(hiveConfigType.Equals(TEXT("airbridgeAppName")))
    {
        Type = EHiveConfigType::AirbridgeAppName;
    }
    else if(hiveConfigType.Equals(TEXT("airbridgeSecretId")))
    {
        Type = EHiveConfigType::AirbridgeSecretId;
    }
    else if(hiveConfigType.Equals(TEXT("airbridgeSecret")))
    {
        Type = EHiveConfigType::AirbridgeSecret;
    }
    else
    {
        Type = EHiveConfigType::GoogleServerClientId;
    }
    
    FHiveConfiguration::SetConfigurations(Type, value);
}

void UConfigurationsKeyView::SetDefaultValue()
{
    mGoogleServerClientId = TEXT("331526026701-42uadtkeght91f7saspdg92gtdill6mv.apps.googleusercontent.com");
    mGooglePlayGamesServerClientId = TEXT("331526026701-42uadtkeght91f7saspdg92gtdill6mv.apps.googleusercontent.com");
    
#if PLATFORM_IOS
    mWechatSecretKey = TEXT("b5a73b0ee67d546bf876851944eda308");
    mWechatPaymentKey = TEXT("auILMZisSYHnEb4ISD58QYm7uETdVX6d");
    
    mAdjustKey = TEXT("8szd9kddtt6o");
#else
    mWechatSecretKey = TEXT("26dcee99df49b6da27bc0fa160d15219");
    mWechatPaymentKey = TEXT("auILMZisSYHnEb4ISD58QYm7uETdVX6d");
    
    mAdjustKey = TEXT("f02nseiur2m8");
#endif
    
    mSingularKey = TEXT("9b7ff73a0fc13c6c9397a9881dba2673");
    mAppsFlyerKey = TEXT("G6yEQjHw4CrEN8sEzF9onU");

    mAirbridgeKey = TEXT("f3de25a6990b433b8179046d04d10faf");
    mAirbridgeAppName = TEXT("hivesdksample");
    mAirbridgeSecretId = TEXT("ae085840-d4bd-4fd0-ae5f-b91464394359");
    mAirbridgeSecret = TEXT("65d4ce93e0c3a7a1881e0b2ae190e0f86996228153c233f49b54890f46d2fa4b");
}

void UConfigurationsKeyView::SetEmptyValue()
{
    mGoogleServerClientId = TEXT("");
    mGooglePlayGamesServerClientId = TEXT("");
    
    mWechatSecretKey = TEXT("");
    mWechatPaymentKey = TEXT("");
    
    mAdjustKey = TEXT("");
    
    mSingularKey = TEXT("");
    mAppsFlyerKey = TEXT("");

    mAirbridgeKey = TEXT("");
    mAirbridgeAppName = TEXT("");
    mAirbridgeSecretId = TEXT("");
    mAirbridgeSecret = TEXT("");
}
