//
//  ConfigurationsKeyView.h
//  HIVESDKV4Tester
//
//  Created by disker on 2021/07/08.
//  Copyright © 2021 Epic Games, Inc. All rights reserved.
//

#pragma once

#include "HiveConfiguration.h"

#include "ConfigurationsKeyView.generated.h"


UCLASS(BlueprintType)
class HIVESDKV4TESTER_API UConfigurationsKeyView : public UObject
{
    GENERATED_BODY()
    
public:
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mGoogleServerClientId;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mGooglePlayGamesServerClientId;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mWechatSecretKey;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mWechatPaymentKey;
    
    
    /* Adjust */
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mAdjustKey;
    
    
    /* Analytics */
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mSingularKey;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mAppsFlyerKey;

    /* Airbridge */
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mAirbridgeKey;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mAirbridgeAppName;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mAirbridgeSecretId;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString mAirbridgeSecret;
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|ConfigurationsKeyView")
    void SetConfigurations(FString hiveConfigType, FString value);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|ConfigurationsKeyView")
    void SetDefaultValue();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|ConfigurationsKeyView")
    void SetEmptyValue();
    
};
