//
//  DataStoreTestView.cpp
//  HIVESDKV4Tester
//
//  Created by disker on 2022/04/18.
//  Copyright © 2022 Epic Games, Inc. All rights reserved.
//

#include "DataStoreTestView.h"
#include "HIVESDKV4Tester.h"
#include "HIVESDKV4TesterGameMode.h"


void UDataStoreTestView::SetWithKeyValue(FString key, FString value)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("=== Set(%s, %s) ==="), *key, *value);
    
    FHiveDataStore::Set(key, value, FHiveDataStoreOnSetDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("%s"), *(Result.ToString()));
    }));
}


void UDataStoreTestView::SetWithData(FString key1, FString value1, FString key2, FString value2, FString key3, FString value3)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("=== Set(data) ==="));
    
    TMap<FString, FString> Data;
    
    if(!(key1.IsEmpty()))
    {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("Data Set(%s, %s)"), *key1, *value1);
        Data.Emplace(key1, value1);
    }
    
    if(!(key2.IsEmpty()))
    {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("Data Set(%s, %s)"), *key2, *value2);
        Data.Emplace(key2, value2);
    }
    
    if(!(key3.IsEmpty()))
    {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("Data Set(%s, %s)"), *key3, *value3);
        Data.Emplace(key3, value3);
    }
    
    FHiveDataStore::Set(Data, FHiveDataStoreOnSetDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("%s"), *(Result.ToString()));
    }));
}


void UDataStoreTestView::GetWithKey(FString key)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("=== Get(%s) ==="), *key);
    
    FHiveDataStore::Get(key, FHiveDataStoreOnGetDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FString& Data) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("%s\nData = %s"), *(Result.ToString()), *Data);
    }));
}


void UDataStoreTestView::GetMyData()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("=== GetMyData() ==="));
    
    FHiveDataStore::GetMyData(FHiveDataStoreOnMyDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const DataStoreData& MyData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("%s"), *(Result.ToString()));
        
        if (Result.IsSuccess())
        {
            AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("[MyData]"));
            
            for (const auto& Pair : MyData)
            {
                AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("[%s, %s]"), *(Pair.Key), *(Pair.Value));
            }
        }
    }));
}


void UDataStoreTestView::GetUsersData(FString key)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("=== GetUsersData(%s) ==="), *key);
    
    FHiveDataStore::GetUsersData(key, FHiveDataStoreOnUsersDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FString& Key, const DataStoreUsersData& UsersData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("%s\nKey = %s"), *(Result.ToString()), *Key);
        
        if (Result.IsSuccess())
        {
            AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("[UsersData]"));
            
            for (const auto& Pair : UsersData)
            {
                AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::DataStore, TEXT("[%lld, %s]"), Pair.Key, *(Pair.Value));
            }
        }
    }));
}
