/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "HIVESDKV4TesterGameMode.h"
#include "HIVESDKV4Tester.h"
#include <sstream>

#if PLATFORM_ANDROID
//#include "Runtime/Core/Public/Android/AndroidApplication.h"
//#include "Runtime/Launch/Public/Android/AndroidJNI.h"
//#include "Android/AndroidJNI.h"
//#include "Android/AndroidApplication.h"
#endif

#if PLATFORM_IOS
#include "Runtime/ApplicationCore/Public/iOS/IOSAppDelegate.h"
//#include <HIVE_SDK/HIVEAppDelegate.h>
#import <AdSupport/AdSupport.h>
#endif

#define STARTING_BUFFER_SIZE		512

#include "IImageWrapperModule.h"
#include "IImageWrapper.h"

#include "HIVESDK.h"
#include "ChatParamView.h"
#include "UObject/ConstructorHelpers.h"

AHIVESDKV4TesterGameMode * AHIVESDKV4TesterGameMode::gameModeInstance = nullptr;

//const FString InvitationImageName = TEXT("temporalQRImage.png");

//VARARG_BODY( void, AHIVESDKV4TesterGameMode::appendLogString, const TCHAR*, VARARG_EXTRA(ELogType type))
void AHIVESDKV4TesterGameMode::appendLogString(ELogType type, const TCHAR* Fmt, ...)
{
    int32		BufferSize	= STARTING_BUFFER_SIZE;
    TCHAR	StartingBuffer[STARTING_BUFFER_SIZE];
    TCHAR*	Buffer		= StartingBuffer;
    int32		Result		= -1;
    
    // First try to print to a stack allocated location
    GET_TYPED_VARARGS_RESULT( TCHAR, Buffer, BufferSize, BufferSize-1, Fmt, Fmt, Result );
    
    // If that fails, start allocating regular memory
    if( Result == -1 )
    {
        Buffer = nullptr;
        while(Result == -1)
        {
            BufferSize *= 2;
            Buffer = (TCHAR*) FMemory::Realloc( Buffer, BufferSize * sizeof(TCHAR) );
            GET_TYPED_VARARGS_RESULT(TCHAR, Buffer, BufferSize, BufferSize-1, Fmt, Fmt, Result );
        };
    }
    
    Buffer[Result] = 0;
    
    FString ResultString(Buffer);
    
    if( BufferSize != STARTING_BUFFER_SIZE )
    {
        FMemory::Free( Buffer );
    }
    UE_LOG(LogTemp, Warning, TEXT("%s"),*ResultString);
    gStrLog.Append(ResultString);
    gStrLog.Append(TEXT("\n"));
	AsyncTask(ENamedThreads::GameThread, [this, ResultString, type]() {
	//Need GameThread (Debug Build)
			OnUpdateGlobalLog.Broadcast(ResultString);
			switch (type) {
                case ELogType::SocialV4:
                    OnUpdateSocialV4Log.Broadcast(ResultString);
                    break;
				case ELogType::Promotion:
					OnUpdatePromotionLog.Broadcast(ResultString);
					break;
				case ELogType::Push:
					OnUpdatePushLog.Broadcast(ResultString);
					break;
				case ELogType::Analytics:
					OnUpdateAnalyticsLog.Broadcast(ResultString);
					break;
				case ELogType::AuthV4:
					OnUpdateAuthV4Log.Broadcast(ResultString);
					break;
				case ELogType::AuthV4Helper:
					OnUpdateAuthV4HelperLog.Broadcast(ResultString);
					break;
				case ELogType::IAPV4:
					OnUpdateIAPV4Log.Broadcast(ResultString);
					break;
				case ELogType::Provider:
					OnUpdateProviderLog.Broadcast(ResultString);
					break;
                case ELogType::DataStore:
                    OnUpdateDataStoreLog.Broadcast(ResultString);
                    break;
                case ELogType::PlatformHelper:
                    OnUpdatePlatformHelperLog.Broadcast(ResultString);
                    break;
                case ELogType::Configuration:
                    OnUpdateConfigurationLog.Broadcast(ResultString);
                    break;
                case ELogType::MatchMaking:
                    OnUpdateMatchMakingLog.Broadcast(ResultString);
                    break;
                case ELogType::Chat:
                    OnUpdateChatLog.Broadcast(ResultString);
                    break;
				default:
					break;
			}
	});

}

void AHIVESDKV4TesterGameMode::appendLogStringNoNewLine(ELogType type, const TCHAR* Fmt, ...)
{
    int32        BufferSize    = STARTING_BUFFER_SIZE;
    TCHAR    StartingBuffer[STARTING_BUFFER_SIZE];
    TCHAR*    Buffer        = StartingBuffer;
    int32        Result        = -1;
    
    // First try to print to a stack allocated location
    GET_TYPED_VARARGS_RESULT( TCHAR, Buffer, BufferSize, BufferSize-1, Fmt, Fmt, Result );
    
    // If that fails, start allocating regular memory
    if( Result == -1 )
    {
        Buffer = nullptr;
        while(Result == -1)
        {
            BufferSize *= 2;
            Buffer = (TCHAR*) FMemory::Realloc( Buffer, BufferSize * sizeof(TCHAR) );
            GET_TYPED_VARARGS_RESULT( TCHAR, Buffer, BufferSize, BufferSize-1, Fmt, Fmt, Result );
        };
    }
    
    Buffer[Result] = 0;
    
    FString ResultString(Buffer);
    
    if( BufferSize != STARTING_BUFFER_SIZE )
    {
        FMemory::Free( Buffer );
    }
    UE_LOG(LogTemp, Warning, TEXT("%s"),*ResultString);
    gStrLog.Append(ResultString);
    AsyncTask(ENamedThreads::GameThread, [this, ResultString, type]() {
    //Need GameThread (Debug Build)
            OnUpdateGlobalLog.Broadcast(ResultString);
            switch (type) {
                case ELogType::SocialV4:
                    OnUpdateSocialV4Log.Broadcast(ResultString);
                    break;
                case ELogType::Promotion:
                    OnUpdatePromotionLog.Broadcast(ResultString);
                    break;
                case ELogType::Push:
                    OnUpdatePushLog.Broadcast(ResultString);
                    break;
                case ELogType::Analytics:
                    OnUpdateAnalyticsLog.Broadcast(ResultString);
                    break;
                case ELogType::AuthV4:
                    OnUpdateAuthV4Log.Broadcast(ResultString);
                    break;
                case ELogType::Configuration:
                    OnUpdateConfigurationLog.Broadcast(ResultString);
                    break;
                case ELogType::AuthV4Helper:
                    OnUpdateAuthV4HelperLog.Broadcast(ResultString);
                    break;
                case ELogType::IAPV4:
                    OnUpdateIAPV4Log.Broadcast(ResultString);
                    break;
                case ELogType::Provider:
                    OnUpdateProviderLog.Broadcast(ResultString);
                    break;
                case ELogType::DataStore:
                    OnUpdateDataStoreLog.Broadcast(ResultString);
                    break;
                case ELogType::MatchMaking:
                    OnUpdateMatchMakingLog.Broadcast(ResultString);
                    break;
                case ELogType::Chat:
                    OnUpdateChatLog.Broadcast(ResultString);
                    break;
                default:
                    break;
            }
    });

}

//Run Begin Level's BluePrint.
void AHIVESDKV4TesterGameMode::InitGameMode()
{
#if PLATFORM_IOS
    if([IOSAppDelegate GetDelegate].launchOptions != nil){
        UE_LOG(LogTemp, Warning, TEXT("############ launchOptions : %s"),*FString([[IOSAppDelegate GetDelegate].launchOptions description])
           );
    }
    else
    {
        UE_LOG(LogTemp, Warning, TEXT("############ launchOptions nil")
               );
    }
//    [HIVEAppDelegate application:nil didFinishLaunchingWithOptions:[IOSAppDelegate GetDelegate].launchOptions];
#endif
#if PLATFORM_IOS
    NSLog(@"InitGameMode............ From NS LOG~~~~~~~~~~~~~~~~~~~~~~\n");
    FHIVESDKModule::Get();
#endif
    AHIVESDKV4TesterGameMode::gameModeInstance = this;
	
    this->configurationsKeyView = NewObject<UConfigurationsKeyView>();
    this->playerTestViewInstance = NewObject<UPlayerTestView>();
    this->iapV4TestViewInstance = NewObject<UIAPV4TestView>();
    this->providerTestViewInstance = NewObject<UProviderTestView>();
    this->promotionTestViewInstance = NewObject<UPromotionTestView>();
    this->socialV4TestViewInstance = NewObject<USocialV4TestView>();
    this->platformHelperTestViewInstance = NewObject<UPlatformHelperTestView>();
    this->dataStoreTestViewInstance = NewObject<UDataStoreTestView>();
    this->matchMakingTestViewInstance = NewObject<UMatchMakingTestView>();
    this->chatTestViewInstance = NewObject<UChatTestView>();
}

AHIVESDKV4TesterGameMode * AHIVESDKV4TesterGameMode::getGameModeInstance()
{
    return AHIVESDKV4TesterGameMode::gameModeInstance;
}

//Social Start
//Social End

//Push start
void AHIVESDKV4TesterGameMode::PushGetRemote()
{
    appendLogString(ELogType::Push ,TEXT("=== GetRemotePush() ==="));
    
    FHivePush::GetRemotePush(FHivePushOnRemotePushDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveRemotePush& RemotePush) {
        appendLogString(ELogType::Push ,TEXT("%s\nIsAgreeNotice = %s, IsAgreeNight = %s"),
                        *(Result.ToString()),
                        RemotePush.IsAgreeNotice ? TEXT("TRUE") : TEXT("FALSE"),
                        RemotePush.IsAgreeNight ? TEXT("TRUE") : TEXT("FALSE"));
        
        if (Result.IsSuccess())
        {
            if(OnUpdateRemotePushInfo.IsBound())
            {
                OnUpdateRemotePushInfo.Broadcast(RemotePush.IsAgreeNotice, RemotePush.IsAgreeNight);
            }
        }
    }));
}

void AHIVESDKV4TesterGameMode::PushSetRemote(bool bNotice, bool bNight)
{
    appendLogString(ELogType::Push ,TEXT("=== SetRemotePush() ==="));
    
    FHiveRemotePush RemotePush(bNotice, bNight);
    FHivePush::SetRemotePush(RemotePush, FHivePushOnRemotePushDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveRemotePush& RemotePush) {
        appendLogString(ELogType::Push ,TEXT("%s\nIsAgreeNotice = %s, IsAgreeNight = %s"),
                        *(Result.ToString()),
                        RemotePush.IsAgreeNotice ? TEXT("TRUE") : TEXT("FALSE"),
                        RemotePush.IsAgreeNight ? TEXT("TRUE") : TEXT("FALSE"));
        
        if (Result.IsSuccess())
        {
            if(OnUpdateRemotePushInfo.IsBound())
            {
                OnUpdateRemotePushInfo.Broadcast(RemotePush.IsAgreeNotice, RemotePush.IsAgreeNight);
            }
        }
    }));
}

void AHIVESDKV4TesterGameMode::PushRegisterLocal(FString title, FString message, FString bigMessage, int after, int noticeID, int red, int green, int blue, int bucketType, int bucketSize, FString groupId, FString type)
{
    FHiveLocalPush LocalPush;
    LocalPush.NoticeId = noticeID;
    LocalPush.Title = title;
    LocalPush.Msg = message;
    LocalPush.After = after;
    LocalPush.Type = type;
    
    LocalPush.GroupId = groupId;
    LocalPush.Bigmsg = bigMessage.Len() > 0 ? bigMessage : TEXT("Local Push Big Message");
    LocalPush.BucketType = bucketType;
    LocalPush.BucketSize = bucketSize > 0 ? bucketSize : 1;
    
    
    // 추가 정보를 담을 FJsonObject 생성
    TSharedPtr<FJsonObject> IconColorJson = MakeShareable(new FJsonObject);
    IconColorJson->SetNumberField(TEXT("r"), (double)red);
    IconColorJson->SetNumberField(TEXT("g"), (double)green);
    IconColorJson->SetNumberField(TEXT("b"), (double)blue);

    // FJsonObject를 문자열로 직렬화
    FString StrIconColor;
    TSharedRef<TJsonWriter<>> JsonWriter = TJsonWriterFactory<>::Create(&StrIconColor);
    FJsonSerializer::Serialize(IconColorJson.ToSharedRef(), JsonWriter);
    
    LocalPush.IconColor = StrIconColor;
    
    appendLogString(ELogType::Push ,TEXT("=== RegisterLocalPush() ==="));
    
    FHivePush::RegisterLocalPush(LocalPush, FHivePushOnLocalPushDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveLocalPush& LocalPush) {
        appendLogString(ELogType::Push, TEXT("%s"), *(Result.ToString()));
    }));
}

void AHIVESDKV4TesterGameMode::PushUnRegisterLocal(int noticeID)
{
    appendLogString(ELogType::Push ,TEXT("=== UnregisterLocalPush(%d) ==="), noticeID);
    
    FHivePush::UnregisterLocalPush(noticeID);
}

void AHIVESDKV4TesterGameMode::PushUnRegisterLocals(int noticeID)
{
    appendLogString(ELogType::Push ,TEXT("=== UnregisterLocalPushes(%d) ==="), noticeID);
    
    TArray<int32> NoticeIds;
    NoticeIds.Add(noticeID);
    
    FHivePush::UnregisterLocalPushes(NoticeIds);
}

void AHIVESDKV4TesterGameMode::PushUnRegisterAllLocal()
{
    appendLogString(ELogType::Push ,TEXT("=== UnregisterAllLocalPushes() ==="));
    FHivePush::UnregisterAllLocalPushes();
}

void AHIVESDKV4TesterGameMode::PushRegisterLocalForStress()
{
    appendLogString(ELogType::Push ,TEXT("=== RegisterLocalPush() for Stress ==="));
    
    for (int i = 1; i<=stressLocalPushCount; i++)
    {
        FHiveLocalPush LocalPush;
        LocalPush.NoticeId = i;
        LocalPush.Title = FString::Printf(TEXT("stress_title_%d"), i);
        LocalPush.Msg = FString::Printf(TEXT("stress_message_%d"), i);
        LocalPush.After = 5 * i;
        
        FHivePushOnLocalPushDelegate Delegate;
        FHivePush::RegisterLocalPush(LocalPush, Delegate);
    }
}

void AHIVESDKV4TesterGameMode::PushUnRegisterLocalForStress()
{
    appendLogString(ELogType::Push ,TEXT("=== UnregisterLocalPush() for Stress ==="));
    
    for (int i = 1; i <= stressLocalPushCount; i++)
    {
        FHivePush::UnregisterLocalPush(i);
    }
}

void AHIVESDKV4TesterGameMode::PushUnRegisterLocalsForStress()
{
    appendLogString(ELogType::Push, TEXT("=== UnregisterLocalPushes() for Stress ==="));
    
    TArray<int32> NoticeIds;
    for (int i = 1; i <= stressLocalPushCount; i++)
    {
        NoticeIds.Add(i);
    }
    FHivePush::UnregisterLocalPushes(NoticeIds);
}

void AHIVESDKV4TesterGameMode::PushRequestPushPermission()
{
#if PLATFORM_IOS || PLATFORM_ANDROID
    appendLogString(ELogType::Push, TEXT("=== RequestPushPermission() ==="));
    FHivePush::RequestPushPermission();
#else
    appendLogString(ELogType::Push, TEXT("This API is only for mobile platform.\n"));
#endif
}

void AHIVESDKV4TesterGameMode::PushSetForeground(bool bLocalPush, bool bRemotePush)
{
    appendLogString(ELogType::Push, TEXT("=== SetForegroundPush() ===\nUseForegroundRemotePush = %s\nUseForegroundLocalPush = %s")
                    ,bRemotePush ? TEXT("TRUE") : TEXT("FALSE")
                    ,bLocalPush ? TEXT("TRUE") : TEXT("FALSE"));
    FHivePushSetting PushSetting(bRemotePush, bLocalPush);
    FHivePush::SetForegroundPush(PushSetting, FHivePushOnPushSettingDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHivePushSetting& PushSetting) {
        appendLogString(ELogType::Push, TEXT("%s"), *(Result.ToString()));
        appendLogString(ELogType::Push, TEXT("Result PushSetting\nUseForegroundRemotePush = %s\nUseForegroundLocalPush = %s")
                        ,PushSetting.UseForegroundRemotePush ? TEXT("TRUE") : TEXT("FALSE")
                        ,PushSetting.UseForegroundLocalPush ? TEXT("TRUE") : TEXT("FALSE"));
    }));
}

void AHIVESDKV4TesterGameMode::PushGetForeground()
{
    appendLogString(ELogType::Push, TEXT("=== GetForegroundPush() ==="));
    FHivePush::GetForegroundPush(FHivePushOnPushSettingDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHivePushSetting& PushSetting) {
        appendLogString(ELogType::Push, TEXT("%s"), *(Result.ToString()));
        appendLogString(ELogType::Push, TEXT("Result PushSetting\nUseForegroundRemotePush = %s\nUseForegroundLocalPush = %s")
                        ,PushSetting.UseForegroundRemotePush ? TEXT("TRUE") : TEXT("FALSE")
                        ,PushSetting.UseForegroundLocalPush ? TEXT("TRUE") : TEXT("FALSE"));
        
        if(OnUpdateForegroundPushInfo.IsBound())
        {
            OnUpdateForegroundPushInfo.Broadcast(PushSetting.UseForegroundLocalPush, PushSetting.UseForegroundRemotePush);
        }
    }));
}

//Push End


//Mobile App Tracking start
void AHIVESDKV4TesterGameMode::AnalyticsSendEvent(FString strEventName)
{
    appendLogString(ELogType::Analytics ,TEXT("=== SendEvent(%s) ==="), *strEventName);
    FHiveAnalytics::SendEvent(strEventName);
}

void AHIVESDKV4TesterGameMode::AnalyticsSendEventWithAttributes(FString strEventName, FString Action, FString Label, FString Value, FString SemanticKey, FString SemanticValue, FString CustomKey, FString CustomValue)
{
    FHiveAnalyticsAttributes AnalyticsAttributes;
    
    FHiveAirbridgeSpecific AirbridgeSpecific;
    if (!Action.IsEmpty()) { AirbridgeSpecific.SetSemanticAction(Action); }
    if (!Label.IsEmpty()) { AirbridgeSpecific.SetSemanticLabel(Label); }
    if (!Value.IsEmpty())
    {
        double fValue = FCString::Atod(*Value);
        AirbridgeSpecific.SetSemanticValue(fValue);
    }
    if (!SemanticKey.IsEmpty() && !SemanticValue.IsEmpty())
    {
        TSharedPtr<FJsonValue> SemanticJsonValue = MakeShareable(new FJsonValueString(SemanticValue));
        AirbridgeSpecific.AddSemanticAttribute(SemanticKey, SemanticJsonValue);
    }

    AnalyticsAttributes.AddModuleSpecificAttribute(AirbridgeSpecific);

    if (!CustomKey.IsEmpty() && !CustomValue.IsEmpty())
    {
        TSharedPtr<FJsonValue> CustomJsonValue = MakeShareable(new FJsonValueString(CustomValue));
        AnalyticsAttributes.AddCustomAttribute(CustomKey, CustomJsonValue);
    }

    FHiveAnalytics::SendEventWithAttributes(strEventName, AnalyticsAttributes);
    appendLogString(ELogType::Analytics, TEXT("=== SendEventWithAttributes(%s) ===\n"), *strEventName);
    appendLogString(ELogType::Analytics, TEXT("[AnalyitcsAttribute]\n%s"), *(AnalyticsAttributes.ToString()));
}

void AHIVESDKV4TesterGameMode::AnalyticsSendAdRevenueEvent(FString revenue, FString adPlatform, FString adUnitId, FString adType, FString adPlacement, FString currency)
{
    FString Message = TEXT("=== SendAdRevenueEvent() ===");
    Message += FString::Printf(TEXT("Revenue = %s\n"), *revenue);
    Message += FString::Printf(TEXT("AdPlatform = %s\n"), *adPlatform);
    Message += FString::Printf(TEXT("AdUnitId = %s\n"), *adUnitId);
    Message += FString::Printf(TEXT("AdType = %s\n"), *adType);
    Message += FString::Printf(TEXT("AdPlacement = %s\n"), *adPlacement);
    Message += FString::Printf(TEXT("Currency = %s\n\n"), *currency);
    
    appendLogString(ELogType::Analytics ,TEXT("%s"), *Message);
    
    
    FHiveAnalyticsAdRevenue AdRevenue;
    AdRevenue.Revenue = FCString::Atod(*revenue);
    AdRevenue.AdPlatform = adPlatform;
    AdRevenue.AdUnitId = adUnitId;
    AdRevenue.AdType = adType;
    AdRevenue.AdPlacement = adPlacement;
    AdRevenue.Currency = currency;
    
    FHiveAnalytics::SendAdRevenueEvent(AdRevenue);
}

void AHIVESDKV4TesterGameMode::AnalyticsSendLog(FString strCategory)
{
    // TSharedPtr로 FJsonObject 생성
    TSharedPtr<FJsonObject> LogData = MakeShareable(new FJsonObject);

    if(strCategory.Equals(TEXT("sdk_test_join")))
    {
        LogData->SetStringField(TEXT("category"), TEXT("com2us_hivesdk_mass_send_log"));
        LogData->SetStringField(TEXT("memo"), TEXT("sdk_test_join"));
    }
    else if(strCategory.Equals(TEXT("sdk_test_login")))
    {
        LogData->SetStringField(TEXT("category"), TEXT("com2us_hivesdk_mass_send_log"));
        LogData->SetStringField(TEXT("memo"), TEXT("sdk_test_login"));
    }
    
    FString SerializedJson;
    TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&SerializedJson);
    FJsonSerializer::Serialize(LogData.ToSharedRef(), Writer);
    
    appendLogString(ELogType::Analytics ,TEXT("=== SendAnalyticsLog() ===\nLogData: %s"), *SerializedJson);
    FHiveAnalytics::SendAnalyticsLog(LogData);
    
}

void AHIVESDKV4TesterGameMode::AnalyticsSetEnableTracker(FString TackerName, bool isEnable)
{
    appendLogString(ELogType::Analytics ,TEXT("=== SetEnableTracker(%s, %s) ==="), *TackerName, isEnable ? TEXT("TRUE") : TEXT("FALSE"));
    FHiveAnalytics::SetEnableTracker(TackerName, isEnable);
}

void AHIVESDKV4TesterGameMode::AnalyticsSetConsent(FString providerName,
                                                   bool isAllowConsentAdStorage,
                                                   bool isAllowConsentAdUserData,
                                                   bool isAllowConsentAdPersonalization,
                                                   bool isAllowConsentAnalyticsStorage)
{
    std::string strProviderName(TCHAR_TO_UTF8(*providerName));
    
    std::map<std::string, std::string> consentSettings;
    consentSettings[HIVE_SDK_ANALYTICS_CONSENT_TYPE_AD_STORAGE]         = getConsentStatus(isAllowConsentAdStorage);
    consentSettings[HIVE_SDK_ANALYTICS_CONSENT_TYPE_AD_USER_DATA]       = getConsentStatus(isAllowConsentAdUserData);
    consentSettings[HIVE_SDK_ANALYTICS_CONSENT_TYPE_AD_PERSONALIZATION] = getConsentStatus(isAllowConsentAdPersonalization);
    consentSettings[HIVE_SDK_ANALYTICS_CONSENT_TYPE_ANALYTICS_STORAGE]  = getConsentStatus(isAllowConsentAnalyticsStorage);
    
    Analytics::setConsent(strProviderName, consentSettings);
    
    appendLogString(ELogType::Analytics ,TEXT("Analytics::setConsent"));
}

std::string AHIVESDKV4TesterGameMode::getConsentStatus(bool isAllow)
{
    return isAllow ? HIVE_SDK_ANALYTICS_CONSENT_GRANTED : HIVE_SDK_ANALYTICS_CONSENT_DENIED;
}

void AHIVESDKV4TesterGameMode::AnalyticsGetConsent(FString providerName)
{
    std::string strProviderName(TCHAR_TO_UTF8(*providerName));
    std::map<std::string, std::string> result = Analytics::getConsent(strProviderName);
    
    if(result.empty()) {
        appendLogString(ELogType::Analytics ,TEXT("Analytics::getConsent result is empty."));
        return;
    }
    
    std::stringstream ss;
    for (const std::pair<std::string, std::string> pairData : result) {
        ss << pairData.first << ", " << pairData.second << "\n";
    }
    std::string strResult = ss.str();
    appendLogString(ELogType::Analytics ,TEXT("Analytics::getConsent result\n%s"), *FString(strResult.c_str()));
}

void AHIVESDKV4TesterGameMode::AnalyticsShowConsentModeIfRequire()
{
    appendLogString(ELogType::Analytics ,TEXT("=== ShowConsentModeIfRequire() ==="));
    
    TOptional<FHiveConsentMode> CustomData = TOptional<FHiveConsentMode>();
    FHiveAnalytics::ShowConsentModeIfRequire(true, CustomData, FHiveAnalyticsOnShowConsentModeDelegate::CreateLambda([this](const FHiveResultAPI& Result, const TArray<FHiveConsentStatus>& ConsentStatusList) {
        appendLogString(ELogType::Analytics ,TEXT("%s"), *(Result.ToString()));
        
        for (const auto& ConsentStatus : ConsentStatusList)
        {
            FString Message = TEXT("<<ConsentStatus>>");
            Message += FString::Printf(TEXT("Id = %s"), *ConsentStatus.Id);
            Message += FString::Printf(TEXT("Granted = %s"), *ConsentStatus.Granted);
            Message += FString::Printf(TEXT("ConsentDate = %d"), ConsentStatus.ConsentDate);
            Message += FString::Printf(TEXT("ExpiredDate = %d"), ConsentStatus.ExpiredDate);
            appendLogString(ELogType::Analytics ,TEXT("%s\n"), *Message);
        }
        appendLogString(ELogType::Analytics ,TEXT("\n"));
    }));
}

void AHIVESDKV4TesterGameMode::AnalyticsShowConsentMode()
{
    appendLogString(ELogType::Analytics ,TEXT("=== ShowConsentMode() ==="));
    
    TOptional<FHiveConsentMode> CustomData = TOptional<FHiveConsentMode>();
    FHiveAnalytics::ShowConsentMode(CustomData, FHiveAnalyticsOnShowConsentModeDelegate::CreateLambda([this](const FHiveResultAPI& Result, const TArray<FHiveConsentStatus>& ConsentStatusList) {
        appendLogString(ELogType::Analytics ,TEXT("%s"), *(Result.ToString()));
        
        for (const auto& ConsentStatus : ConsentStatusList)
        {
            FString Message = TEXT("<<ConsentStatus>>");
            Message += FString::Printf(TEXT("Id = %s"), *ConsentStatus.Id);
            Message += FString::Printf(TEXT("Granted = %s"), *ConsentStatus.Granted);
            Message += FString::Printf(TEXT("ConsentDate = %d"), ConsentStatus.ConsentDate);
            Message += FString::Printf(TEXT("ExpiredDate = %d"), ConsentStatus.ExpiredDate);
            appendLogString(ELogType::Analytics ,TEXT("%s\n"), *Message);
        }
        appendLogString(ELogType::Analytics ,TEXT("\n"));
    }));
}

void AHIVESDKV4TesterGameMode::AnalyticsShowConsentModeWithCustomData()
{
    appendLogString(ELogType::Analytics ,TEXT("=== ShowConsentMode(CustomData) ==="));
    
    TOptional<FHiveConsentMode> CustomData = TOptional<FHiveConsentMode>(GetExampleCustomConsentMode());
    FHiveAnalytics::ShowConsentMode(CustomData, FHiveAnalyticsOnShowConsentModeDelegate::CreateLambda([this](const FHiveResultAPI& Result, const TArray<FHiveConsentStatus>& ConsentStatusList) {
        appendLogString(ELogType::Analytics ,TEXT("%s"), *(Result.ToString()));
        
        for (const auto& ConsentStatus : ConsentStatusList)
        {
            FString Message = TEXT("<<ConsentStatus>>");
            Message += FString::Printf(TEXT("Id = %s"), *ConsentStatus.Id);
            Message += FString::Printf(TEXT("Granted = %s"), *ConsentStatus.Granted);
            Message += FString::Printf(TEXT("ConsentDate = %d"), ConsentStatus.ConsentDate);
            Message += FString::Printf(TEXT("ExpiredDate = %d"), ConsentStatus.ExpiredDate);
            appendLogString(ELogType::Analytics ,TEXT("%s\n"), *Message);
        }
        appendLogString(ELogType::Analytics ,TEXT("\n"));
    }));
}

FHiveConsentForm AHIVESDKV4TesterGameMode::GetExampleCustomConsentForm(FString Id)
{
    FHiveConsentForm CustomConsentForm;
    CustomConsentForm.Id = Id;
    CustomConsentForm.RetentionPeriod = 14;
    CustomConsentForm.Title = FString::Printf(TEXT("[%s] Test Title"), *Id);
    CustomConsentForm.Content = FString::Printf(TEXT("[%s]\n\n Test content"), *Id);

    return CustomConsentForm;
}

FHiveConsentMode AHIVESDKV4TesterGameMode::GetExampleCustomConsentMode()
{
    FHiveConsentMode CustomConsentMode;
    CustomConsentMode.Title = TEXT("Test Custom Data Title");
    CustomConsentMode.CompanyName = TEXT("Com2usPlatform_Client");
    CustomConsentMode.PrivacyPolicy = TEXT("https://www.com2us.com");
    
    CustomConsentMode.AdUserData = TOptional<FHiveConsentForm>(GetExampleCustomConsentForm(TEXT("ad_user_data")));
    CustomConsentMode.AdPersonalization = TOptional<FHiveConsentForm>(GetExampleCustomConsentForm(TEXT("ad_personalization")));
    CustomConsentMode.AnalyticsStorage = TOptional<FHiveConsentForm>(GetExampleCustomConsentForm(TEXT("analytics_storage")));

    TArray<FString> SubFormIds = {
        TEXT("Firebase Anlaytics"),
        TEXT("Adjust"),
        TEXT("Singular"),
        TEXT("Appsflyer"),
        TEXT("Airbridge")
    };

    for (const FString& SubFormId : SubFormIds) {
        CustomConsentMode.AdPersonalization.GetValue().SubForms.Emplace(GetExampleCustomConsentForm(SubFormId));
    }
    
    return CustomConsentMode;
}

//Mobile App tracking end
void AHIVESDKV4TesterGameMode::AndroidTestFunction()
{
    UE_LOG(LogTemp, Warning, TEXT("Run AndroidTestFunction"));

//    Auth::initialize(std::bind(&AHIVESDKV4TesterGameMode::exampleOnAuthInitialize, this, std::placeholders::_1, std::placeholders::_2)
//                     );
}

FString AHIVESDKV4TesterGameMode::getProjectVersion()
{
    FString ProjectVersion;
#if PLATFORM_ANDROID
    GConfig->GetString(
                       TEXT("/Script/AndroidRuntimeSettings.AndroidRuntimeSettings"),
                       TEXT("VersionDisplayName"),
                       ProjectVersion,
                       GEngineIni
                       );
#elif PLATFORM_IOS
    NSString * version = [[NSBundle mainBundle] objectForInfoDictionaryKey: @"CFBundleVersion"];
    ProjectVersion = FString(version);
#endif
    return ProjectVersion;
}

FString AHIVESDKV4TesterGameMode::getIDFA()
{
    FString idfa;
#if PLATFORM_IOS
    idfa = FString([[[ASIdentifierManager sharedManager] advertisingIdentifier] UUIDString]);
#endif
    return idfa;
}

FString AHIVESDKV4TesterGameMode::getIDFV()
{
    FString idfv;
#if PLATFORM_IOS
    idfv = FString([[[[UIDevice currentDevice] identifierForVendor] UUIDString] UTF8String]);
#endif
    return idfv;
}

void AHIVESDKV4TesterGameMode::SetEngagementReady(bool isReady)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::AuthV4 ,TEXT("SetEngagementReady(%s)"),isReady ? TEXT("TRUE"):TEXT("FALSE"));
    
    TOptional<FHiveResultAPI> Result = FHivePromotion::SetEngagementReady(isReady);
    if (Result.IsSet())
    {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::AuthV4 ,TEXT("setEngagementReady result = %s"), *(Result.GetValue().ToString()));
    }
}