/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

//#if PLATFORM_ANDROID

//#elif PLATFORM_IOS

#if PLATFORM_IOS
#include "CPP/HIVE_CPP.h"
#else
#include "HIVE_CPP.h"
#endif
using namespace hive;

#include "HiveAnalytics.h"
#include "HivePush.h"

#include "ConfigurationsKeyView.h"
#include "PlayerTestView.h"
#include "IAPV4TestView.h"
#include "ProviderTestView.h"
#include "PromotionTestView.h"
#include "SocialV4TestView.h"
#include "PlatformHelperTestView.h"
#include "DataStoreTestView.h"
#include "MatchMakingTestView.h"
#include "ChatTestView.h"
#include "GameFramework/GameMode.h"
#include "HIVESDKV4TesterGameMode.generated.h"

USTRUCT(BlueprintType)
struct FTestAppIAPSeriesInfo
{
    GENERATED_BODY()
public:
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    int FTestAppIAPseriesSeq;						///< 시리즈 상품 순번.
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    int FTestAppIAPseriesTotalCount;				///< 시리즈 상품 수.
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    int FTestAppIAPseriesPurchaseStatus;			///< 시리즈 구매전(1), 구매완료(2)
};

USTRUCT(BlueprintType)
struct FTestIAPProduct
{
    GENERATED_BODY()
public:
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPgamePid;					///< HIVE IAP 시스템에서 관리하는 하나의 상품을 지칭하는 고유 코드
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPmarketPid;					///< 마켓에 등록된 고유 상품 ID
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPcurrency;					///< 통화 코드 (ex, KRW / USD)
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    float TestAppIAPprice;							///< 상품 가격
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPdisplayPrice;				///< 상품 가격 문자열 (ex. $100.00)
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPtitle;						///< 상품 타이틀
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPdescription;				///< 상품 설명
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPproductImageUrl;			///< 상품 이미지 url
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPbadgeImageUrl;				///< 뱃지 이미지 url
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPtitleLandscapeImageUrl;		///< 상품 타이틀 이미지 (가로)
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPtitlePortraitImageUrl;		///< 상품 타이틀 이미지 (세로)
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPdescLandscapeImageUrl;		///< 상품 설명 이미지 (가로)
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPdescPortraitImageUrl;		///< 상품 설명 이미지 (세로)
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPoriginalJson;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FDateTime TestAppIAPsalesStartUTC;						///< 상품 시작시간, 
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FDateTime TestAppIAPsalesExpireUTC;					///< 상품 만료시간,
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString productType;				///< 상품타입. general(일반상품), series(시리즈 상품)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FTestAppIAPSeriesInfo seriesInfo;               ///< 시리즈 상품의 정보
};

USTRUCT(BlueprintType)
struct FTestAppShopInfo
{
    GENERATED_BODY()
public:
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPlocationCode;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    int TestAppIAPshopId;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPshopType;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    bool TestAppIAPbadgeExist;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPbadgeImageUrl;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString TestAppIAPoriginalJson;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TArray<FTestIAPProduct> TestAppIAPproductList;
};


enum class ELogType
{
    Analytics,
    AuthV4,
    AuthV4Helper,
    Configuration,
    DataStore,
    IAPV4,
    PlatformHelper,
    Promotion,
    Provider,
    Push,
    SocialV4,
    MatchMaking,
    Chat,
};


/**
 * 
 */
UCLASS(BlueprintType)
class HIVESDKV4TESTER_API AHIVESDKV4TesterGameMode : public AGameMode
{
	GENERATED_BODY()
	
	
public:
    // 로컬 푸시 스트레스 테스트. 등록 가능한 최대 수(iOS 낮은 os 등록 기준)
    static const int stressLocalPushCount = 64;
    
    static AHIVESDKV4TesterGameMode * gameModeInstance;
    
    static AHIVESDKV4TesterGameMode * getGameModeInstance();
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    UConfigurationsKeyView *configurationsKeyView;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    UPlayerTestView *playerTestViewInstance;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    UIAPV4TestView *iapV4TestViewInstance;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    UProviderTestView *providerTestViewInstance;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    UPromotionTestView *promotionTestViewInstance;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    USocialV4TestView *socialV4TestViewInstance;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    UPlatformHelperTestView *platformHelperTestViewInstance;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    UDataStoreTestView *dataStoreTestViewInstance;


    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    UMatchMakingTestView *matchMakingTestViewInstance;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    UChatTestView *chatTestViewInstance;

    //Local Log System
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString gStrLog;

	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString modeStrLanguage;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString modeStrServerID;

    // Regular text log
//    VARARG_DECL( void, void, return, appendLogString, VARARG_NONE, const TCHAR*, VARARG_EXTRA(ELogType type), VARARG_EXTRA(type));

    void appendLogString(ELogType type, const TCHAR* Fmt, ...);
    void appendLogStringNoNewLine(ELogType type, const TCHAR* Fmt, ...);
    
    DECLARE_DYNAMIC_MULTICAST_DELEGATE(FTestAppNoParamDelegate);
    
    DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FTestAppOnUpdateLog, FString, appendString);

    DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FTestAppOnPushInfo, bool, notice, bool, night);

    UPROPERTY(BlueprintAssignable)
    FTestAppOnPushInfo OnUpdateRemotePushInfo;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnPushInfo OnUpdateForegroundPushInfo;
    
    UPROPERTY(BlueprintAssignable)
    FTestAppNoParamDelegate OnUpdateShopInfo;
    
    UPROPERTY(BlueprintAssignable)
    FTestAppNoParamDelegate OnUpdateIAPV4ProductInfo;

	UPROPERTY(BlueprintAssignable)
	FTestAppNoParamDelegate OnUpdateIAPV4SubscriptionProductInfo;

	UPROPERTY(BlueprintAssignable)
	FTestAppNoParamDelegate OnExitPopupSampleForAndroid;

    UPROPERTY(BlueprintAssignable)
    FTestAppNoParamDelegate OnUpdateGetStoredPlayerIdList;

    UPROPERTY(BlueprintAssignable)
    FTestAppNoParamDelegate OnUpdateSetAutoLoginEnabled;
    
    UPROPERTY(BlueprintAssignable)
    FTestAppNoParamDelegate OnRequestPostBoxLogin;
    
    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateMarketInfo; //Use One Param Delegate
    
    //Hive Webview notice ifno Delegate
    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateGlobalLog;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdatePromotionLog;
    
    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateSocialV4Log;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdatePlatformHelperLog;
    
    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateDataStoreLog;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdatePushLog;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateAnalyticsLog;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateAuthV4Log;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateConfigurationLog;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateAuthV4HelperLog;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateIAPV4Log;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateProviderLog;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateMatchMakingLog;

    UPROPERTY(BlueprintAssignable)
    FTestAppOnUpdateLog OnUpdateChatLog;

    //Shop Info Struct
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FTestAppShopInfo testAppShopInfo;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    int testAppIAPBalance;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString testAppZone;


    UFUNCTION(BlueprintCallable,Category="The TEST")
    void InitGameMode();

    //Auth
    UFUNCTION(BlueprintCallable,Category="The TEST")
    void AndroidTestFunction();

    //social

    //Push
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushGetRemote();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushSetRemote(bool bNotice, bool bNight);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PushRegisterLocal(FString title, FString message, FString bigMessage, int after, int noticeID, int red, int green, int blue, int bucketType, int bucketSize, FString groupId, FString type);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushUnRegisterLocal(int noticeID);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushUnRegisterLocals(int noticeID);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushUnRegisterAllLocal();
    
    /* Stress Test 검증 기능 */
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushRegisterLocalForStress();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushUnRegisterLocalForStress();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushUnRegisterLocalsForStress();
    /* End (Stress Test 검증 기능) */
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushRequestPushPermission();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushSetForeground(bool bLocalPush, bool bRemotePush);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PushGetForeground();

    //Mobile App Tracking
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void AnalyticsSendEvent(FString strEventName);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4")
    void AnalyticsSendEventWithAttributes(FString strEventName, FString Action, FString Label, FString Value, FString SemanticKey, FString SemanticValue, FString CustomKey, FString CustomValue);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void AnalyticsSendAdRevenueEvent(FString revenue, FString adPlatform, FString adUnitId, FString adType, FString adPlacement, FString currency);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void AnalyticsSendLog(FString strCategory);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void AnalyticsSetEnableTracker(FString TackerName, bool isEnable);
    
    // Chat Test View Instance Getter
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Chat")
    UChatTestView* GetChatTestViewInstance() { return chatTestViewInstance; }
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void AnalyticsSetConsent(FString providerName, bool isAllowConsentAdStorage, bool isAllowConsentAdUserData, bool isAllowConsentAdPersonalization, bool isAllowConsentAnalyticsStorage);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void AnalyticsGetConsent(FString providerName);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void AnalyticsShowConsentModeIfRequire();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void AnalyticsShowConsentMode();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void AnalyticsShowConsentModeWithCustomData();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    FString getProjectVersion();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    FString getIDFA();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    FString getIDFV();
    
    //print setReady result on Auth V1 Log
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void SetEngagementReady(bool isReady);
    
private:
    std::string getConsentStatus(bool isAllow);
    
    FHiveConsentForm GetExampleCustomConsentForm(FString Id);
    FHiveConsentMode GetExampleCustomConsentMode();

};

#if PLATFORM_IOS
#import <UIKit/UIKit.h>

@interface AppDelegate : UIResponder <UIApplicationDelegate>

@end
#endif
