/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "HIVEV4TesterPlatformGameInstance.h"
#include "HIVESDKV4Tester.h"

#include "HardwareInfo.h"	//	FHardwareInfo::GetHardwareInfo


#if PLATFORM_IOS
#include "Runtime/ApplicationCore/Public/iOS/IOSAppDelegate.h"
#endif
#if PLATFORM_WINDOWS
#include "Windows/WindowsHWrapper.h"
#endif

void UHIVEV4TesterPlatformGameInstance::Init()
{
#if PLATFORM_IOS
    NSLog(@"##############################InitGame Platform Instance.............. From NS LOG~~~~~~~~~~~~~~~~~~~~~~\n");
    //OpenURL Delegate Regist
	// Add Custom OpenURL delegate (OnOpenURLwithOptions) on ApplicationCore-IOSAppDelegate
	FIOSCoreDelegates::OnOpenURLwithOptions.AddUObject(this, &UHIVEV4TesterPlatformGameInstance::ApplicationOpenURL);
#endif


#if PLATFORM_WINDOWS && !WITH_EDITOR
	UE_LOG(LogTemp, Warning, TEXT("############ Windows HIVESDKTester Will Check DUpllicate"));

	/*
		// Try to open the mutex.
		HANDLE hMutex = OpenMutex(
			MUTEX_ALL_ACCESS, 0, TEXT("HIVESDKV4UE"));

		if (!hMutex)
			hMutex =
			CreateMutex(0, 0, TEXT("HIVESDKV4UE"));
		else {
			// The mutex exists so this is the
			// the second instance so return.
			UE_LOG(LogTemp, Warning, TEXT("############ Windows HIVESDKTester this App Duplicated Run!"));
			PostQuitMessage(0);	//	Or FPlatformMisc::RequestExit()?
			FPlatformMisc::RequestExit(true);
		}
		*/
#endif
    Super::Init();
}

UHIVEV4TesterPlatformGameInstance::~UHIVEV4TesterPlatformGameInstance() {
	UE_LOG(LogTemp, Warning, TEXT("############ UHIVEV4TesterPlatformGameInstance::~UHIVEV4TesterPlatformGameInstance"));
#if PLATFORM_WINDOWS && !WITH_EDITOR
	UE_LOG(LogTemp, Warning, TEXT("############ Windows HIVESDKTester Will Check DUpllicate"));

	// Try to open the mutex.
	HANDLE hMutex = OpenMutex(
		MUTEX_ALL_ACCESS, 0, TEXT("HIVESDKV4UE"));
	if (!hMutex) {
		UE_LOG(LogTemp, Warning, TEXT("Mutex is Not Exist."));
	}
	else {
		// The mutex exists so this is the
		// the second instance so return.
		ReleaseMutex(hMutex);
	}
#endif
}
#if PLATFORM_IOS
void UHIVEV4TesterPlatformGameInstance::ApplicationOpenURL(UIApplication* application, NSURL* url, NSDictionary* options)
{
    NSLog(@"##############################OpenURL Delegate Called####################################");
    NSLog(@"############################## absoluteString = %@",[url absoluteString]);
    
    Promotion::processURI(std::string([[url absoluteString] UTF8String]));
}
#endif

void UHIVEV4TesterPlatformGameInstance::RemoveOpenURLDelegate()
{
    UE_LOG(LogTemp, Warning, TEXT("############ RemoveOpenURLDelegate called"));
#if PLATFORM_IOS
    NSLog(@"############################## RemoveOpenURLDelegate called ####################################");
    FIOSCoreDelegates::OnOpenURL.Clear();
	FIOSCoreDelegates::OnOpenURLwithOptions.Clear();
    if([IOSAppDelegate GetDelegate].launchOptions != nil){
        UE_LOG(LogTemp, Warning, TEXT("############ launchOptions : %s"),*FString([[IOSAppDelegate GetDelegate].launchOptions description])
               );
		//HIVE SDK 4.13.0, Unreal 4.23  need manually run UserEnagement with RemoteNotification when app not running.
		NSDictionary *remoteNotification = [IOSAppDelegate GetDelegate].launchOptions[UIApplicationLaunchOptionsRemoteNotificationKey];
		if (remoteNotification) {
			NSString *pushAction = [IOSAppDelegate GetDelegate].launchOptions[UIApplicationLaunchOptionsRemoteNotificationKey][@"action"];
			
			NSURL *pushActionUrl = [NSURL URLWithString:pushAction];
			if (![pushAction isKindOfClass:[NSNull class]]) {
				Promotion::processURI(std::string([[pushActionUrl absoluteString] UTF8String]));
			}
		}
    }
    else
    {
        UE_LOG(LogTemp, Warning, TEXT("############ launchOptions nil")
               );
    }
	UIApplication * dummyApplication = [UIApplication sharedApplication];
	if(dummyApplication != nil)
		NSLog(@"############################## dummyApplication exist................\n");
	else
		NSLog(@"############################## dummyApplication is nil................\n");
	
	NSLog(@"############################## RemoveOpenURLDelegate Before................\n");

	Class clzHIVEAppDelegate = NSClassFromString(@"HIVEAppDelegate");
	SEL selApplicationDidFinishLaunchingWithOptions = NSSelectorFromString(@"application:didFinishLaunchingWithOptions:");
	if( clzHIVEAppDelegate != nil && [clzHIVEAppDelegate respondsToSelector:selApplicationDidFinishLaunchingWithOptions] ) {
		NSMethodSignature *method = [clzHIVEAppDelegate methodSignatureForSelector:selApplicationDidFinishLaunchingWithOptions];
		if (method != nil) {
			
			NSInvocation *invocation = [NSInvocation invocationWithMethodSignature:method];
			[invocation setSelector:selApplicationDidFinishLaunchingWithOptions];
			[invocation setTarget:clzHIVEAppDelegate];
			[invocation setArgument:(void*)&dummyApplication atIndex:2];
			NSDictionary *localLaunchOptions = [IOSAppDelegate GetDelegate].launchOptions;
			if( localLaunchOptions != nil ) {
				[invocation setArgument:(void*)&localLaunchOptions atIndex:3];
			}
			[invocation invoke];
		}
	}
	NSLog(@"############################## RemoveOpenURLDelegate Done ..............\n");

#endif
}

FString UHIVEV4TesterPlatformGameInstance::GetRuntimeRHIInfo() {
	return FHardwareInfo::GetHardwareInfo(NAME_RHI);
}
