/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#if PLATFORM_IOS
#include "CPP/HIVE_CPP.h"
#else
#include "HIVE_CPP.h"
#endif
using namespace hive;

#include "Kismet/BlueprintPlatformLibrary.h"
#include "HIVEV4TesterPlatformGameInstance.generated.h"

/**
 * 
 */
UCLASS()
class HIVESDKV4TESTER_API UHIVEV4TesterPlatformGameInstance : public UPlatformGameInstance
{
	GENERATED_BODY()
	
	
	void Init() override;
	virtual ~UHIVEV4TesterPlatformGameInstance() override;
#if PLATFORM_IOS
	void ApplicationOpenURL(UIApplication* application, NSURL* url, NSDictionary * options);
//    void ApplicationOpenURL(UIApplication* application, NSURL* url, NSString* sourceApplication, id annotation);
#endif
public:
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void RemoveOpenURLDelegate();

	UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4")
	FString GetRuntimeRHIInfo();

};
