/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "TestAppGameNetwork.h"

#include "HiveIAPV4.h"
#include "HiveConfiguration.h"

#include "IAPV4TestView.generated.h"

USTRUCT(BlueprintType)
struct FTestIAPV4Product
{
    GENERATED_BODY()
public:
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString v4MarketPid;					///< 마켓에 등록된 고유 상품 ID
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString v4Currency;					///< 통화 코드 (ex, KRW / USD)
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    float v4Price;							///< 상품 가격
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString v4DisplayPrice;				///< 상품 가격 문자열 (ex. $100.00)
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString v4Title;						///< 상품 타이틀
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString v4ProductDescription;				///< 상품 설명
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString v4DisplayOriginalPrice;				///< (before discount ) 상품 가격 문자열 (ex. $100.00)

    friend FArchive& operator<<(FArchive& Ar, FTestIAPV4Product& product)
    {
        return Ar << product.v4MarketPid << product.v4Currency << product.v4Price << product.v4DisplayPrice << product.v4Title << product.v4ProductDescription << product.v4DisplayOriginalPrice;
    }
};

USTRUCT(BlueprintType)
struct FTestIAPV4Receipt
{
    GENERATED_BODY()
public:
//    UPROPERTY(EditAnywhere, BlueprintReadWrite)
//    HIVEHiveIAPV4Type marketType;							///
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FTestIAPV4Product product;					///
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString hiveiapReceipt;					///
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString iapPayload;				///
    friend FArchive& operator<<(FArchive& Ar, FTestIAPV4Receipt& recipt)
    {
        return Ar << recipt.product << recipt.hiveiapReceipt << recipt.iapPayload;
    }
};

USTRUCT(BlueprintType)
struct FTestIAPV4ShopInfo
{
    GENERATED_BODY()
public:
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString v4LocationCode;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    int v4ShopId;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString v4ShopType;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    bool v4BadgeExist;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString v4BadgeImageUrl;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TArray<FTestIAPV4Product> TestproductList;
};


UCLASS(BlueprintType)
class HIVESDKV4TESTER_API UIAPV4PostBoxItem : public UObject
{
    GENERATED_BODY()
public:
    UPROPERTY()
    TArray<FTestIAPV4Receipt> mPOSTBOXV4PurchasedInfoNew;
//    FArchive& operator<< dosen't activate..
//    friend FArchive& operator<<(FArchive& Ar, UIAPV4PostBoxItem& iapV4recipt)
};


/**
 * 
 */
UCLASS(BlueprintType)
class HIVESDKV4TESTER_API UIAPV4TestView : public UObject
{
	GENERATED_BODY()

public:
    //Product Info Struct (Member Variable)
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TArray<FTestIAPV4Product> mIAPV4ProductInfo;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    int mIAPV4Balance;

    //IAPV4
//    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
//    void IAPV4PostBox();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4marketConnect();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4GetMarketProductInfo(FString marketPidListString);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4getProductInfo();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4purchase(FString strMarketPid, FString strIapPayload, FString quantity);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4restore();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4showMarketSelection();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4getBalanceInfo();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4getAccountUuid();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4showCharge();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4checkPromotePurchase();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
	void IAPV4getSubscriptionProductInfo();
    
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
	void IAPV4purchaseSubscription(FString strMarketPid, FString strOldMarketPid, FString strIapPayload);

	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
	void IAPV4restoreSubscription();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4getSelectedMarket();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4ShowInAppMessages(FString categoryId);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|IAPV4")
    void IAPV4GetConsumeInfoAgreement();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|IAPV4")
    void IAPV4ShowConsumeInfoAgreement();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|IAPV4")
    void IAPV4FinishTransactions();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|IAPV4")
    void IAPV4FinishAllTransactions();

	
    //POSTBOX
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TArray<FTestIAPV4Receipt> mPOSTBOXV4PurchasedInfo;

    UPROPERTY()
    class UIAPV4PostBoxItem * iapv4PostBoxItems;
    
    TestAppGameNetwork::FGameListener verifyReceiptListener;
    
    void gameVerifyReceiptListener(bool result, ITestAppGameNetworkResponse response);
    
private:
    std::vector<std::string> split (std::string s, std::string delimiter);
    
    FString DecodeBase64(const FString& BypassInfo);
    void PrintFHiveIAPV4Product(const FHiveIAPV4Product& Product);
    void PrintFHiveIAPV4Receipt(const FHiveIAPV4Receipt& Receipt);
    
    void purchase(FString strMarketPid, FString strIapPayload);
    void purchaseQuantity(FString strMarketPid, FString strIapPayload, FString quantity);

};

UENUM(BlueprintType)
enum class ETestIAPItemType : uint8
{
	CONSUMABLE
	, SUBSCRIPTION
};
