//
//  MatchMakingTestView.cpp
//  HIVESDKV4Tester
//
//  Created by herohjk on 2024/11/25.
//  Copyright © 2022 Epic Games, Inc. All rights reserved.
//

// #include "DataStoreTestView.h"
// #include "HIVESDKV4Tester.h"
// #include "HIVESDKV4TesterGameMode.h"

#include "MatchMakingTestView.h"
#include "HIVESDKV4Tester.h"
#include "HIVESDKV4TesterGameMode.h"

void UMatchMakingTestView::PrintMatchMakingData(const FHiveMatchMakingData& MatchMakingData)
{
    FString PlayerInfosStr = TEXT("");
    for (const FHiveMatchingResultPlayerInfo& PlayerInfo : MatchMakingData.matchingPlayerInfoList)
    {
        PlayerInfosStr += FString::Printf(TEXT("{ playerId: %lld point: %d extraData: %s }\n"), PlayerInfo.playerId, PlayerInfo.point, *PlayerInfo.extraData);
    }

    FString TeamInfosStr = TEXT("");
    for (const FHiveMatchingResultTeamInfo& TeamInfo : MatchMakingData.matchingTeamInfoList)
    {
        TeamInfosStr += FString::Printf(TEXT("{ teamIndex: %d, players: ["), TeamInfo.teamIndex);
        
        for (int32 i = 0; i < TeamInfo.playerInfos.Num(); ++i)
        {
            const auto& PlayerInfo = TeamInfo.playerInfos[i];
            TeamInfosStr += FString::Printf(TEXT("{ playerId: %lld, point: %d, extraData: %s }"), 
                PlayerInfo.playerId, 
                PlayerInfo.point, 
                *PlayerInfo.extraData);
            
            if (i < TeamInfo.playerInfos.Num() - 1)
            {
                TeamInfosStr += TEXT(", ");
            }
        }
        
        TeamInfosStr += TEXT("] }\n");
    }

    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking,
        TEXT("MatchMakingData:\nrequestPlayerId %lld\nrequestGameIndex %d\nrequestMatchId %d\nrequestStatus %s\nrequestTimeUtc %s\nrequestPoint %d\nrequestExtraData %s\nmatchingStatus %s\nmatchingId %s\nmatchingType %s\n, PlayerInfosStr %s\nTeamInfosStr %s"),
        MatchMakingData.requestPlayerId,
        MatchMakingData.requestGameIndex,
        MatchMakingData.requestMatchId,
        *MatchMakingData.requestStatus,
        *MatchMakingData.requestTimeUtc,
        MatchMakingData.requestPoint,
        *MatchMakingData.requestExtraData,
        *MatchMakingData.matchingStatus,
        *MatchMakingData.matchingId,
        *MatchMakingData.matchingType,
        *PlayerInfosStr,
        *TeamInfosStr
    );
}

void UMatchMakingTestView::PrintMatchMakingGroupData(const FHiveMatchMakingGroupData& MatchMakingGroupData)
{
   FString memberInfoListString = TEXT("");
   for (const FHiveMatchingMemberInfo& MemberInfo : MatchMakingGroupData.memberInfoList)
   {
       memberInfoListString += FString::Printf(TEXT("{ playerId: %lld, ready: %s, point: %d, extraData: %s }\n"), MemberInfo.playerId, MemberInfo.ready ? TEXT("TRUE") : TEXT("FALSE"), MemberInfo.point, *MemberInfo.extraData);
   }

   FString matchingTeamInfoListString = TEXT("");
   for (const FHiveMatchingResultTeamInfo& TeamInfo : MatchMakingGroupData.matchingTeamInfoList)
   {
       matchingTeamInfoListString += FString::Printf(TEXT("{ teamIndex: %d, players: ["), TeamInfo.teamIndex);
       
       for (int32 i = 0; i < TeamInfo.playerInfos.Num(); ++i)
       {
           const auto& PlayerInfo = TeamInfo.playerInfos[i];
           matchingTeamInfoListString += FString::Printf(TEXT("{ playerId: %lld, point: %d, extraData: %s }"), 
               PlayerInfo.playerId, 
               PlayerInfo.point, 
               *PlayerInfo.extraData);
           
           if (i < TeamInfo.playerInfos.Num() - 1)
           {
               matchingTeamInfoListString += TEXT(", ");
           }
       }
       
       matchingTeamInfoListString += TEXT("] }\n");
   }
   
   AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking,
       TEXT("groupCode %s\nownerPlayerId %lld\nmemberInfoList %s\nrequestGameIndex %d\nrequestMatchId %d\nrequestStatus %s\nrequestTimeUtc %s\nmatchingStatus %s\nmatchingId %s\nmatchingType %s\nmatchingTeamInfoList %s"),
       *MatchMakingGroupData.groupCode,
       MatchMakingGroupData.ownerPlayerId,
       *memberInfoListString,
       MatchMakingGroupData.requestGameIndex,
       MatchMakingGroupData.requestMatchId,
       *MatchMakingGroupData.requestStatus,
       *MatchMakingGroupData.requestTimeUtc,
       *MatchMakingGroupData.matchingStatus,
       *MatchMakingGroupData.matchingId,
       *MatchMakingGroupData.matchingType,
       *matchingTeamInfoListString
   );
}

void UMatchMakingTestView::RequestMatchMaking(FString MatchIdStr, FString PointStr, FString ExtraData)
{
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    int32 Point = FCString::Atoi(*PointStr);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== RequestMatchMaking(%d, %d, %s) ==="), MatchId, Point, *ExtraData);
    FHiveMatchMaking::RequestMatchMaking(MatchId, Point, ExtraData, FHiveMatchMakingOnMatchMakingDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveMatchMakingData& MatchMakingData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
        PrintMatchMakingData(MatchMakingData);
    }));
}

void UMatchMakingTestView::GetRequestingStatus(FString MatchIdStr)
{
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== GetRequestingStatus(%d) ==="), MatchId);
    FHiveMatchMaking::GetRequestingStatus(MatchId, FHiveMatchMakingOnMatchMakingDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveMatchMakingData& MatchMakingData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
        PrintMatchMakingData(MatchMakingData);
    }));
}

void UMatchMakingTestView::DeleteRequesting(FString MatchIdStr)
{
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== DeleteRequesting(%d) ==="), MatchId);
    FHiveMatchMaking::DeleteRequesting(MatchId, FHiveMatchMakingOnResultDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
    }));
}


void UMatchMakingTestView::CreateGroup(FString MatchIdStr, FString PointStr, FString ExtraData)
{
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    int32 Point = FCString::Atoi(*PointStr);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== CreateGroup(%d, %d, %s) ==="), MatchId, Point, *ExtraData);
    FHiveMatchMaking::CreateGroup(MatchId, Point, ExtraData, FHiveMatchMakingOnMatchMakingGroupDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveMatchMakingGroupData& MatchMakingGroupData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
        PrintMatchMakingGroupData(MatchMakingGroupData);
    }));
}

void UMatchMakingTestView::JoinGroup(FString MatchIdStr, FString GroupCode, FString PointStr, FString ExtraData)
{
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    int32 Point = FCString::Atoi(*PointStr);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== JoinGroup(%d, %s, %d, %s) ==="), MatchId, *GroupCode, Point, *ExtraData);
    FHiveMatchMaking::JoinGroup(MatchId, GroupCode, Point, ExtraData, FHiveMatchMakingOnMatchMakingGroupDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveMatchMakingGroupData& MatchMakingGroupData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
        PrintMatchMakingGroupData(MatchMakingGroupData);
    }));
}

void UMatchMakingTestView::LeaveGroup(FString MatchIdStr)
{
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== LeaveGroup(%d) ==="), MatchId);
    FHiveMatchMaking::LeaveGroup(MatchId, FHiveMatchMakingOnResultDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
    }));
}
    
void UMatchMakingTestView::KickGroupUser(FString MatchIdStr, FString TargetPlayerIdStr)
{
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    int64 TargetPlayerId = FCString::Atoi64(*TargetPlayerIdStr);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== KickGroupUser(%d, %lld) ==="), MatchId, TargetPlayerId);
    FHiveMatchMaking::KickGroupUser(MatchId, TargetPlayerId, FHiveMatchMakingOnMatchMakingGroupDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveMatchMakingGroupData& MatchMakingGroupData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
        PrintMatchMakingGroupData(MatchMakingGroupData);
    }));
}

void UMatchMakingTestView::GetGroupInfoByUser(FString MatchIdStr)
{
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== GetGroupInfoByUser(%d) ==="), MatchId);
    FHiveMatchMaking::GetGroupInfoByUser(MatchId, FHiveMatchMakingOnMatchMakingGroupDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveMatchMakingGroupData& MatchMakingGroupData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
        PrintMatchMakingGroupData(MatchMakingGroupData);
    }));
}
    
void UMatchMakingTestView::GetGroupInfoByGroupCode(FString GroupCode)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== GetGroupInfoByGroupCode(%s) ==="), *GroupCode);
    FHiveMatchMaking::GetGroupInfoByGroupCode(GroupCode, FHiveMatchMakingOnMatchMakingGroupDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveMatchMakingGroupData& MatchMakingGroupData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
        PrintMatchMakingGroupData(MatchMakingGroupData);
    }));
}
    
void UMatchMakingTestView::UpdateGroupUser(FString MatchIdStr, bool Ready, FString PointStr, FString ExtraData)
{
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    int32 Point = FCString::Atoi(*PointStr);

    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== UpdateGroupUser(%d, %s, %d, %s) ==="), MatchId, Ready ? TEXT("TRUE") : TEXT("FALSE"), Point, *ExtraData);
    FHiveMatchMaking::UpdateGroupUser(MatchId, Ready, Point, ExtraData, FHiveMatchMakingOnMatchMakingGroupDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveMatchMakingGroupData& MatchMakingGroupData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
        PrintMatchMakingGroupData(MatchMakingGroupData);
    }));
}
        
void UMatchMakingTestView::RequestGroupMatching(FString MatchIdStr){
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== RequestGroupMatching(%d) ==="), MatchId);
    FHiveMatchMaking::RequestGroupMatching(MatchId, FHiveMatchMakingOnMatchMakingGroupDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveMatchMakingGroupData& MatchMakingGroupData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
        PrintMatchMakingGroupData(MatchMakingGroupData);
    }));
}

void UMatchMakingTestView::DeleteGroupMatching(FString MatchIdStr){
    int32 MatchId = FCString::Atoi(*MatchIdStr);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("=== DeleteGroupMatching(%d) ==="), MatchId);
    FHiveMatchMaking::DeleteGroupMatching(MatchId, FHiveMatchMakingOnMatchMakingGroupDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveMatchMakingGroupData& MatchMakingGroupData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::MatchMaking, TEXT("%s"), *(Result.ToString()));
        PrintMatchMakingGroupData(MatchMakingGroupData);
    }));
}