/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "HiveMatchMaking.h"
#include "HiveConfiguration.h"

#include "UObject/Object.h"
#include "MatchMakingTestView.generated.h"

UCLASS(BlueprintType)
class HIVESDKV4TESTER_API UMatchMakingTestView : public UObject
{
    GENERATED_BODY() // for auto generation constructor
    
public:
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void RequestMatchMaking(FString MatchIdStr, FString PointStr, FString ExtraData);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void GetRequestingStatus(FString MatchIdStr);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void DeleteRequesting(FString MatchIdStr);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void CreateGroup(FString MatchIdStr, FString PointStr, FString ExtraData);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void JoinGroup(FString MatchIdStr, FString GroupCode, FString PointStr, FString ExtraData);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void LeaveGroup(FString MatchIdStr);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void KickGroupUser(FString MatchIdStr, FString TargetPlayerIdStr);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void GetGroupInfoByUser(FString MatchIdStr);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void GetGroupInfoByGroupCode(FString GroupCode);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void UpdateGroupUser(FString MatchIdStr, bool Ready, FString PointStr, FString ExtraData);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void RequestGroupMatching(FString MatchIdStr);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|MatchMaking")
    void DeleteGroupMatching(FString MatchIdStr);

private:
    void PrintMatchMakingData(const FHiveMatchMakingData& MatchMakingData);
    void PrintMatchMakingGroupData(const FHiveMatchMakingGroupData& MatchMakingGroupData);
};