/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#include "MyTextBlock.h"
#include "HIVESDKV4Tester.h"
#include "Internationalization/BreakIterator.h"
#include "Widgets/SInvalidationPanel.h"




#define LOCTEXT_NAMESPACE "UMG"

/////////////////////////////////////////////////////
// UMyUserWidget

#if WITH_EDITOR
const FText UMyTextBlock::GetPaletteCategory()
{
    return LOCTEXT("", "LineBreakTextBlock");
}
#endif

TSharedRef<SWidget> UMyTextBlock::RebuildWidget()
{
    if (bWrapWithInvalidationPanel && !IsDesignTime())
    {
        TSharedPtr<SWidget> RetWidget = SNew(SInvalidationPanel)
        [
         SAssignNew(MyTextBlock, STextBlock)
         ];
        return RetWidget.ToSharedRef();
    }
    else
    {
        MyTextBlock = SNew(STextBlock).LineBreakPolicy(FBreakIterator::CreateCharacterBoundaryIterator());
        return MyTextBlock.ToSharedRef();
    }
}
#undef LOCTEXT_NAMESPACE

