#include "PlatformHelperTestView.h"
#include "HIVESDKV4Tester.h"
#include "HIVESDKV4TesterGameMode.h"

void UPlatformHelperTestView::ShowInAppBrowser(FString url, FString navigationColor, FString buttonColor, bool urlBarHiding, bool autoRedirectToExternalBrowser)
{
    #if PLATFORM_IOS || PLATFORM_ANDROID
    FHiveInAppBrowserParam Param(url);
    Param.NavigationColor = navigationColor;
    Param.ButtonColor = buttonColor;
    Param.UrlBarHiding = urlBarHiding;
    Param.AutoRedirectToExternalBrowser = autoRedirectToExternalBrowser;
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::PlatformHelper ,TEXT("=== ShowInAppBrowser(%s, %s, %s, %s, %s) ==="), *url, *navigationColor, *buttonColor, urlBarHiding ? TEXT("true") : TEXT("false"), autoRedirectToExternalBrowser ? TEXT("true") : TEXT("false"));
    FHivePlatformHelper::ShowInAppBrowser(Param, FHivePlatformHelperOnShowInAppBrowserDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::PlatformHelper ,TEXT("%s\n"), *(ResultAPI.ToString()));
    }));
    #endif
}

void UPlatformHelperTestView::OpenBrowser(FString url, bool userIncognitoMode)
{
    #if PLATFORM_WINDOWS
    FHiveOpenBrowserParam Param(url);
    Param.UseIncognitoMode = userIncognitoMode;

    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::PlatformHelper, TEXT("=== OpenBrowser() ==="));
    FHivePlatformHelper::OpenBrowser(Param);
    #endif
}

void UPlatformHelperTestView::ShowInAppWebView(FString url, FString postData, bool useUserSession, bool useGameWindow)
{
    #if PLATFORM_IOS || PLATFORM_ANDROID || PLATFORM_WINDOWS
    FHiveInAppWebViewParam Param(url);
    Param.PostData = postData;
    Param.UseUserSession = useUserSession;
    Param.UseGameWindow = useGameWindow;

    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(
        ELogType::PlatformHelper,
        TEXT("=== ShowInAppWebView(%s, %s, %s, %s) ==="),
        *url,
        *postData,
        useUserSession ? TEXT("true") : TEXT("false"),
        useGameWindow ? TEXT("true") : TEXT("false")
    );

    FHivePlatformHelper::ShowInAppWebView(Param, FHivePlatformHelperOnShowInAppWebViewDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::PlatformHelper ,TEXT("%s\n"), *(ResultAPI.ToString()));
    }));
    #endif
}

void UPlatformHelperTestView::GetLaunchParameters()
{
    #if PLATFORM_WINDOWS
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::PlatformHelper, TEXT("=== GetLaunchParameters==="));
    FHivePlatformHelper::GetLaunchParameters(FHivePlatformHelperOnGetLaunchParametersDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI, const FString& parameters) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::PlatformHelper, TEXT("%s\nParameters: %s\n"), *(ResultAPI.ToString()), *parameters);
    }));
    #endif
}