/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "TestAppGameNetwork.h"

#include "HiveAuthV4.h"
#include "HivePromotion.h"
#include "HiveConfiguration.h"
#include "HivePlatformHelper.h"

#include "PlayerTestView.generated.h"


/**
 * 
 */
UCLASS(BlueprintType)
class HIVESDKV4TESTER_API UPlayerTestView : public UObject
{
//    GENERATED_BODY()
    GENERATED_UCLASS_BODY()
private:
    void InitAutoLoginEnabled();
public:
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TArray<int> mProviderTypeList;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    bool bAutoLoginEnabled;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TArray<int64> mPlayerIdList;
    
    bool bAutoSignIn;

    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerSetup();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    bool PlayerGetSignInType();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerSignIn(FString providerType);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void SignInWithAuthKey(FString customProviderName, FString customProviderUserId);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerSignOut();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerDelete();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerConnect(FString providerType);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerDisconnect(FString providerType);
    
    UFUNCTION(BlueprintCallable, Category="HIVE SDK V4")
    void PlayerConnectWithAuthKey(FString customProviderName, FString customProviderUserId);

    UFUNCTION(BlueprintCallable, Category="HIVE SDK V4")
    void PlayerDisconnectWithName(FString customProviderName);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4")
    void PlayerRefreshAccessToken();
        
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerSelectConflict(FString selectedPlayerId);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerShowConflictSelection();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerCheckProvider(FString providerType);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerCheckMaintenance(bool isShow);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerCheckBlacklist(bool isShow);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerSetProviderChangedHandler();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerShowSignIn();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerShowTerms();
    
    UFUNCTION(BlueprintCallable, Category="HIVE SDK V4")
    void PlayerResetAgreement();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerShowAdultConfirm();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerGetProfile(FString playerIdlist);// vector/ array
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerShowProfile(FString playerId);// single PlayerID

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    bool PlayerIsAutoSignIn();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerGetPlayerInfo();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerGetParentalConsentInfo();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerSetEngagementReady(bool isReady);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerGetProviderFriendsList();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerResolveConflict();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PlayerShowGameCenterLoginCancelDialog();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PlayerRequestPermissionViewData();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	bool PlayerGetAgeGateU13();

	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PlayerRequestPlatformHelperPermission(FString permissions);
	
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4")
    void PlayerShowInquiry();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4")
    void PlayerShowMyInquiry();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4")
    void PlayerShowChatbotInquiry();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4")
    void PlayerShowDeviceManagement();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void PlayerSignInWithStoredPlayerId(FString playerId, bool useAutoSignIn);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void PlayerStoreCurrentPlayerId();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void PlayerGetStoredPlayerIdList();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void PlayerDeleteStoredPlayerId(FString playerId);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void PlayerDeleteStoredPlayerIdAll();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void PlayerGetHashedDi();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void PlayerShowIdentityVerification();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void GetAgeRange();

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void ShowAgeRangeUpdatePermission(FString Description);
    

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void PlayerCheckAgeGate(bool UseCloseButton);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|AuthV4")
    void PlayerSetAutoLoginEnabled(bool enabled);
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
	void PlayerHelperShowSignIn();
	
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperSignIn();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperSignOut();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperDelete();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperConnect(FString providerType);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperDisconnect(FString providerType);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperGetIDPList();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperSyncAccount(FString providerType);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperShowAchievements();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperShowLeaderboard();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperShowConflict();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
	void PlayerHelperShowConflict2();
	
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperSwitchAccount();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperResolveConflict();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|AuthV4 Helper")
    void PlayerHelperShowGameCenterLoginCancelDialog();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    FString GetHiveCountry();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Config")
    void HIVEConfigurationGetMetaData(FString key, FString forceReload);
    
    FHivePlayerInfo mCurrentPlayer;
    FHivePlayerInfo mConflictPlayer;
    
    void postCustomAuthKey(bool result, ITestAppGameNetworkResponse response);
    void postCustomAuthKeyConnect(bool result, ITestAppGameNetworkResponse response);

    void RequestPostBoxLogin();

};

void PrintFHivePlayerInfo(const FHivePlayerInfo& PlayerInfo, int logType);
void PrintAgeRange(const FHiveAuthV4AgeRange& AgeRange);
