/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#include "PostBoxItemConsumable.h"
#include "HIVESDKV4Tester.h"
#include "TestAppGameNetwork.h"
#include "PostBoxUI.h"


void UPostBoxItemConsumable::NativeConstruct()
{
    Super::NativeConstruct();

    if (Button_Receive)
    {
        Button_Receive->OnClicked.AddDynamic(this, &UPostBoxItemConsumable::receivePost);
    }
}

void UPostBoxItemConsumable::InitPostData(TSharedPtr<FJsonObject> postData)
{
    postInfo.postId = postData->GetStringField(TEXT("post_id"));
	postInfo.assetCode = postData->GetStringField(TEXT("asset_code"));
	postInfo.userMsg = postData->GetStringField(TEXT("user_msg"));
	postInfo.dateAdded = postData->GetStringField(TEXT("date_added"));
	postInfo.assetAmount = postData->GetIntegerField(TEXT("asset_amount"));
	postInfo.characterKey = postData->GetStringField(TEXT("character_key"));

    TextBlock_PostId->SetText(FText::FromString(postInfo.postId));
    TextBlock_Code->SetText(FText::FromString(postInfo.assetCode));

    FString AmountString = FString::FromInt(postInfo.assetAmount);
    TextBlock_Amount->SetText(FText::FromString(AmountString));
    TextBlock_Message->SetText(FText::FromString(postInfo.userMsg));
    TextBlock_DateAdded->SetText(FText::FromString(postInfo.dateAdded));
    TextBlock_CharacterKey->SetText(FText::FromString(postInfo.characterKey));
}
void UPostBoxItemConsumable::receivePost()
{
    TArray<UPostBoxItemConsumable*> postIDList;
    postIDList.Add(this);
    
    UPostBoxUI* dialogInstance = UPostBoxUI::getPostBoxDialogInstance();
    
    
    if(dialogInstance->receiveListener.IsBound())
    {
        dialogInstance->receiveListener.Unbind();
    }
    dialogInstance->receiveListener.BindUObject(dialogInstance, &UPostBoxUI::postReceiveListener);
    
    UE_LOG(LogTemp, Warning, TEXT( "====>>>> PostBoX Try receivePost :  %s"), *(postInfo.postId));

    TestAppGameNetwork::postReceive(dialogInstance->receiveListener, postIDList);
}