/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "Blueprint/UserWidget.h"
#include "Components/Button.h"
#include "Components/TextBlock.h"
#include "PostBoxItemConsumable.generated.h"

USTRUCT(BlueprintType)
struct FPostBoxItemInfoConsumable
{
    GENERATED_BODY()
public:
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString postId; //that's mean game session token. not lc_session(loginCenter)
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString assetCode;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString userMsg;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString dateAdded;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    int assetAmount;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString characterKey;
};


UCLASS()
class HIVESDKV4TESTER_API UPostBoxItemConsumable : public UUserWidget
{
	GENERATED_BODY()
	
public:
    virtual void NativeConstruct() override; // 위젯이 생성되어 화면에 표시될 때(초기화 시점) 자동으로 호출됨

    UPROPERTY(meta = (BindWidget)) 
    UButton* Button_Receive;

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_PostId;

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_Code;

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_Amount;

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_Message;    

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_DateAdded;

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_CharacterKey;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FPostBoxItemInfoConsumable postInfo;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString PostId;

	void InitPostData(TSharedPtr<FJsonObject> postData);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|PostBox")
    void receivePost();

private:

};
