/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "Blueprint/UserWidget.h"
#include "Components/TextBlock.h"
#include "PostBoxItemSubscription.generated.h"

USTRUCT(BlueprintType)
struct FPostBoxSubscriptionItemInfo
{
    GENERATED_BODY()
public:
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString productId;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString marketId;    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString startDate;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString endDate;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString characterKey;
};


UCLASS()
class HIVESDKV4TESTER_API UPostBoxItemSubscription : public UUserWidget
{
	GENERATED_BODY()
	
public:
    virtual void NativeConstruct() override; // 위젯이 생성되어 화면에 표시될 때(초기화 시점) 자동으로 호출됨

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_ProductId;

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_MarketId;    

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_StartDate;

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_EndDate;

    UPROPERTY(meta = (BindWidget)) 
    UTextBlock* TextBlock_CharacterKey;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FPostBoxSubscriptionItemInfo postSubsInfo;

	void InitPostData(TSharedPtr<FJsonObject> postData);

private:

};
