/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#include "PostBoxUI.h"
#include "HIVESDKV4Tester.h"
#include "HIVESDKV4TesterGameMode.h"

UPostBoxUI * UPostBoxUI::postBoxDialog = nullptr;

void UPostBoxUI::NativeConstruct()
{
    Super::NativeConstruct();

    // 버튼 클릭 이벤트 바인딩
    if (Button_Back)
    {
        Button_Back->OnClicked.AddDynamic(this, &UPostBoxUI::OnBackClicked);
    }

    if (Button_Refresh)
    {
        Button_Refresh->OnClicked.AddDynamic(this, &UPostBoxUI::RequestPostBoxList);
    }
    
    RequestPostBoxList();
}

void UPostBoxUI::NativeDestruct()
{
    if (postListener.IsBound())
    {
        postListener.Unbind();
    }

    if (receiveListener.IsBound())
    {
        receiveListener.Unbind();
    }

    if (Button_Back && Button_Back->OnClicked.IsBound())
    {
        Button_Back->OnClicked.RemoveDynamic(this, &UPostBoxUI::OnBackClicked);
    }
    if (Button_Refresh && Button_Refresh->OnClicked.IsBound())
    {
        Button_Refresh->OnClicked.RemoveDynamic(this, &UPostBoxUI::RequestPostBoxList);
    }

    if (ScrollBox_ItemList)
    {
        ScrollBox_ItemList->ClearChildren();
    }

    if (UPostBoxUI::postBoxDialog == this)
    {
        UPostBoxUI::postBoxDialog = nullptr;
    }

    Super::NativeDestruct();
}

void UPostBoxUI::setPostBoxDialogInstance(UPostBoxUI *instance)
{
    UPostBoxUI::postBoxDialog = instance;
}

void UPostBoxUI::RequestPostBoxList()
{
    setPostBoxDialogInstance(this);
    if(postListener.IsBound())
    {
        postListener.Unbind();
    }
    postListener.BindUObject(this, &UPostBoxUI::postListListener);
    TestAppGameNetwork::posts(postListener);
}

void UPostBoxUI::postListListener(bool result, ITestAppGameNetworkResponse response)
{
    if(result)
    {
        if (ScrollBox_ItemList)
        {
            ScrollBox_ItemList->ClearChildren();
        }
		
        TArray<TSharedPtr<FJsonValue>> postSubScriptionList;
        postSubScriptionList = response.resultData->GetArrayField(TEXT("post_subscription_list"));   //JSON OBJ -> TARRAY
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::IAPV4, TEXT( "PostBoxUI Number of SubScriptionPostList Array %d"), postSubScriptionList.Num());

        TArray<UPostBoxItemSubscription*> lSubScriptionPostInfoList;
        for (int32 i = 0; i < postSubScriptionList.Num(); i++) {
            // 위젯 동적 생성
            UPostBoxItemSubscription* PostBoxItemSubscriptionWidget = CreateWidget<UPostBoxItemSubscription>(GetWorld(), PostBoxItemSubscriptionClass);
            if (!PostBoxItemSubscriptionWidget) {
                continue;
            }

            // 상품 데이터 바인딩
            PostBoxItemSubscriptionWidget->InitPostData(postSubScriptionList[i]->AsObject());

            // 스크롤박스에 자식으로 추가
            if (ScrollBox_ItemList)
            {
                ScrollBox_ItemList->AddChild(PostBoxItemSubscriptionWidget);
            }
        }

        //Parsing PostInfo(List)
        TArray<TSharedPtr<FJsonValue>> postInappList;
        postInappList = response.resultData->GetArrayField(TEXT("post_list"));   //JSON OBJ -> TARRAY

        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::IAPV4, TEXT( "PostBoxUI Number of postList Array %d"),postInappList.Num());

        TArray<UPostBoxItemConsumable*> lPostInfoList;
        for (int32 i = 0; i < postInappList.Num(); i++) {
            // 위젯 동적 생성
            UPostBoxItemConsumable* PostBoxItemConsumableWidget = CreateWidget<UPostBoxItemConsumable>(GetWorld(), PostBoxItemConsumableClass);
            if (!PostBoxItemConsumableWidget) {
                continue;
            }

            // 상품 데이터 바인딩
            PostBoxItemConsumableWidget->InitPostData(postInappList[i]->AsObject());

            // 스크롤박스에 자식으로 추가
            if (ScrollBox_ItemList)
            {
                ScrollBox_ItemList->AddChild(PostBoxItemConsumableWidget);
            }
        }

        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::IAPV4, TEXT( "PostBoxUI Before Refresh PostList BroadCast"));
    }
}


void UPostBoxUI::postReceiveListener(bool result, ITestAppGameNetworkResponse response)
{
    if(result)
    {
        UTestAppUserGameInstance* UserGI = UTestAppUserGameInstance::GetInstance(this);
        if (UserGI)
        {
            UserGI->updateListener.ExecuteIfBound(result, response);
        }
        postListener.ExecuteIfBound(result, response);
    }
    else
    {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::IAPV4, TEXT( "PostBoxUI postReceiveListener Fail............... "));
    }
}

void UPostBoxUI::OnBackClicked()
{
    UE_LOG(LogTemp, Warning, TEXT("Back button clicked!"));\
    // 안전 fallback: 자기 자신 제거
    RemoveFromParent();
}

void UPostBoxUI::SetParentUI(UIAPV4TestView* View) 
{ 
    IAPV4TestViewUI = View; 
}