/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "IAPV4TestView.h"
#include "PostBoxItemConsumable.h"
#include "PostBoxItemSubscription.h"
#include "TestAppGameNetwork.h"
#include "TestAppUserGameInstance.h"
#include "Blueprint/UserWidget.h"
#include "Components/Button.h"
#include "Components/ScrollBox.h"
#include "PostBoxUI.generated.h"


UCLASS()
class HIVESDKV4TESTER_API UPostBoxUI : public UUserWidget
{
	GENERATED_BODY()
	
public:
    // UPostBoxUI(const FObjectInitializer& Obj); // 생성자 선언
    virtual void NativeConstruct() override; // 위젯이 생성되어 화면에 표시될 때(초기화 시점) 자동으로 호출됨
    virtual void NativeDestruct() override;

    TWeakObjectPtr<UIAPV4TestView> IAPV4TestViewUI;

    void SetParentUI(UIAPV4TestView* View);

    TestAppGameNetwork::FGameListener postListener;
    void postListListener(bool result, ITestAppGameNetworkResponse response);
    
    TestAppGameNetwork::FGameListener receiveListener;
    void postReceiveListener(bool result, ITestAppGameNetworkResponse response);

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TSubclassOf<UPostBoxItemConsumable> PostBoxItemConsumableClass;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TSubclassOf<UPostBoxItemSubscription> PostBoxItemSubscriptionClass;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TArray<UPostBoxItemConsumable*> postInappListArrayData;

    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TArray<UPostBoxItemSubscription*> postSubScriptionListArrayData;

    UPROPERTY(meta = (BindWidget))
    UButton* Button_Back;

    UPROPERTY(meta = (BindWidget))
    UButton* Button_Refresh;

    // ScrollBox 바인딩
    UPROPERTY(meta = (BindWidget))
    UScrollBox* ScrollBox_ItemList;

    static UPostBoxUI* postBoxDialog;
    //Get Postbox Gameuser Instance.
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|PostBox")
    static UPostBoxUI* getPostBoxDialogInstance()
    {
        return postBoxDialog;
    }
    static void setPostBoxDialogInstance(UPostBoxUI* instance);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void RequestPostBoxList();

private:
    UFUNCTION()
    void OnBackClicked();
};