/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */


#include "PromotionTestView.h"
#include "HIVESDKV4Tester.h"
#include "HIVESDKV4TesterGameMode.h"
#include "IImageWrapperModule.h"
#include "IImageWrapper.h"
#include <sstream>

#include "Math/UnrealMathUtility.h" // FMath::RandRange

#if PLATFORM_IOS || PLATFORM_ANDROID
#else
#undef UpdateResource
#endif

const FString InvitationImageName = TEXT("temporalQRImage.png");

//Promotion Start
void UPromotionTestView::PromotionPromo(FString promoType, bool isForced)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== ShowPromotion(%s, %s) ==="), *promoType, isForced ? TEXT("TRUE") : TEXT("FALSE"));
	
    EHivePromotionType PromotionType = GetEHivePromotionTypeFromName(promoType);
    FHivePromotion::ShowPromotion(PromotionType, isForced, FHivePromotionViewDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI, const EHivePromotionEventType& PromotionEventType) {
        PrintPromotionViewDelegateResult(ResultAPI, PromotionEventType);
    }));
}

void UPromotionTestView::PromotionCustomView(FString strCustomType, FString strViewID)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== ShowCustomContents(%s, %s) ==="), *strCustomType, *strViewID);
    
    EHivePromotionCustomType PromotionCustomType = GetEHivePromotionCustomTypeFromName(strCustomType);
    FHivePromotion::ShowCustomContents(PromotionCustomType, strViewID, FHivePromotionViewDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI, const EHivePromotionEventType& PromotionEventType) {
        PrintPromotionViewDelegateResult(ResultAPI, PromotionEventType);
    }));
}

void UPromotionTestView::PromotionCustomViewOnGameWindow(FString strCustomType, FString strViewID)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== ShowCustomContentsOnGameWindow(%s, %s) ==="), *strCustomType, *strViewID);
    
    EHivePromotionCustomType PromotionCustomType = GetEHivePromotionCustomTypeFromName(strCustomType);
    FHivePromotion::ShowCustomContentsOnGameWindow(PromotionCustomType, strViewID, FHivePromotionViewDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI, const EHivePromotionEventType& PromotionEventType) {
        PrintPromotionViewDelegateResult(ResultAPI, PromotionEventType);
    }));
}

void UPromotionTestView::PromotionShowNews(FString menu, FString giftPidListString)
{
    std::stringstream ss;
    ss.str(TCHAR_TO_UTF8(*giftPidListString));
    
    std::vector<int> giftPidList;
    int giftPid;
    
    while(ss >> giftPid)
    {
        giftPidList.push_back(giftPid);
        if (ss.peek() == ',') ss.ignore();
    }
    
    TArray<int32> GiftPidList;
    for(const auto& item : giftPidList)
    {
        GiftPidList.Add(item);
    }
    
    HIVESDKCEFImeEnable();
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== ShowNews(%s) ==="), *menu);
    
    FHivePromotion::ShowNews(menu, GiftPidList, FHivePromotionViewDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI, const EHivePromotionEventType& PromotionEventType) {
        PrintPromotionViewDelegateResult(ResultAPI, PromotionEventType);
    }));
}

void UPromotionTestView::PromotionRandomGiftPidList() {
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("\n\n=== 선물 상자 노출 랜덤 설정 ===\n"));
    
    FHivePromotion::GetBannerInfo(EHivePromotionCampaignType::ALL, EHivePromotionBannerType::SMALL, FHivePromotionOnBannerInfoDelegate::CreateLambda([this](const FHiveResultAPI& Result, const TArray<FHivePromotionBannerInfo>& PromotionBannerInfoList) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("Result = %s"), *(Result.ToString()));
        
        if (!Result.IsSuccess() || PromotionBannerInfoList.Num() < 1) return;
        
        // 랜덤 인덱스 생성
        int32 RandomIndex = FMath::RandRange(0, PromotionBannerInfoList.Num() - 1);

        // 해당 인덱스에서 Pid 값 추출
        int32 RandomPid = PromotionBannerInfoList[RandomIndex].Pid;
        
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("Random Pid: %d\n"), RandomPid);
        
        fstrGiftPidList = FString::FromInt(RandomPid);
    }));
}

void UPromotionTestView::PromotionGetOfferwallState()
{
    EHiveOfferwallState OfferwallState = FHivePromotion::GetOfferwallState();
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("=== GetOfferwallState() ===\nOfferwallState = %s"), *(GetNameFromEHiveOfferwallState(OfferwallState)));
}

UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
void ConfigurationUpdateServerID(FString serverId);

UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
void ConfigurationUpdateGameLanguage(FString language);

void UPromotionTestView::PromotionOfferwall()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== ShowOfferwall() ==="));
    
    FHivePromotion::ShowOfferwall(FHivePromotionViewDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI, const EHivePromotionEventType& PromotionEventType) {
        PrintPromotionViewDelegateResult(ResultAPI, PromotionEventType);
    }));
}

void UPromotionTestView::PromotionShowNativeReview()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== ShowNativeReview() ==="));
    
    FHivePromotion::ShowNativeReview();
}

void UPromotionTestView::PromotionShowReview()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== ShowReview() ==="));
    
    FHivePromotion::ShowReview(FHivePromotionViewDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI, const EHivePromotionEventType& PromotionEventType) {
        PrintPromotionViewDelegateResult(ResultAPI, PromotionEventType);
    }));
}

void UPromotionTestView::PromotionExit()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== ShowExit() ==="));
    
    FHivePromotion::ShowExit(FHivePromotionViewDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI, const EHivePromotionEventType& PromotionEventType) {
        PrintPromotionViewDelegateResult(ResultAPI, PromotionEventType);
    }));
}

void UPromotionTestView::PromotionGetViewInfo(FString strCustomType, FString strViewID)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== GetViewInfo(%s, %s) ==="), *strCustomType, *strViewID);
    
    EHivePromotionCustomType PromotionCustomType = GetEHivePromotionCustomTypeFromName(strCustomType);
    FHivePromotion::GetViewInfo(PromotionCustomType,
                                strViewID,
                                FHivePromotionOnViewInfoDelegate::CreateLambda([this](const FHiveResultAPI& Result, const TArray<FHivePromotionViewInfo>& PromotionViewInfoList) {
        
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("Result = %s"), *(Result.ToString()));
        
        for(const auto& item : PromotionViewInfoList)
        {
            AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("FHivePromotionViewInfo\nUrl = %s\nPostString = %s\n\n"), *(item.Url), *(item.PostString));
        }
                                                                         
    }));
}

void UPromotionTestView::PromotionGetBadgeInfo()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== GetBadgeInfo() ==="));
    
	FHivePromotion::GetBadgeInfo(FHivePromotionOnBadgeInfoDelegate::CreateLambda([this](const FHiveResultAPI& Result, const TArray<FHivePromotionBadgeInfo>& PromotionBadgeInfoList) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("Result = %s"), *(Result.ToString()));
        
        if (Result.IsSuccess())
        {
            AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("PromotionBadgeInfoList\n"));
            for (const auto& PromotionBadgeInfo : PromotionBadgeInfoList)
            {
                AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("Target = %s\nContentsKey = %s\nBadgeType = %s\n\n"),
                                                                                 *(GetNameFromEHivePromotionBadgeTarget(PromotionBadgeInfo.Target)),
                                                                                 *(PromotionBadgeInfo.ContentsKey),
                                                                                 *(PromotionBadgeInfo.BadgeType));
            }
        }
    }));
}

//for QR Code
static void WriteRawToTexture(UTexture2D* NewTexture2D, const TArray64<uint8>* RawData, bool bUseSRGB = true)
{
	int32 Height = NewTexture2D->GetSizeY();
	int32 Width = NewTexture2D->GetSizeX();
	
	FTexturePlatformData* PlatformData = NewTexture2D->GetPlatformData();
	if (PlatformData && PlatformData->Mips.Num() > 0)
	{
		// Fill in the base mip for the texture we created
		uint8* MipData = (uint8*)PlatformData->Mips[0].BulkData.Lock(LOCK_READ_WRITE);
		for (int32 y = 0; y < Height; y++)
		{
			uint8* DestPtr = &MipData[(Height - 1 - y) * Width * sizeof(FColor)];
			const FColor* SrcPtr = &((FColor*)(RawData->GetData()))[(Height - 1 - y) * Width];
			for (int32 x = 0; x < Width; x++)
			{
				*DestPtr++ = SrcPtr->B;
				*DestPtr++ = SrcPtr->G;
				*DestPtr++ = SrcPtr->R;
				*DestPtr++ = SrcPtr->A;
				SrcPtr++;
			}
		}
		PlatformData->Mips[0].BulkData.Unlock();
	}
	
	// Set options
	NewTexture2D->SRGB = bUseSRGB;
#if WITH_EDITORONLY_DATA
	NewTexture2D->CompressionNone = true;
	NewTexture2D->MipGenSettings = TMGS_NoMipmaps;
#endif
	NewTexture2D->CompressionSettings = TC_EditorIcon;
	
	NewTexture2D->UpdateResource();
	delete RawData;
}

UTexture2D* RawDataToBrush( const TArray< uint8 >& InRawData )
{
    IImageWrapperModule& ImageWrapperModule = FModuleManager::LoadModuleChecked<IImageWrapperModule>(FName("ImageWrapper"));
    TSharedPtr<IImageWrapper> ImageWrappers[1] =
    {
        ImageWrapperModule.CreateImageWrapper(EImageFormat::PNG),
        //        ImageWrapperModule.CreateImageWrapper(EImageFormat::JPEG),
        //        ImageWrapperModule.CreateImageWrapper(EImageFormat::BMP),
    };
    for ( auto ImageWrapper : ImageWrappers )
    {
        if ( ImageWrapper.IsValid() && ImageWrapper->SetCompressed(InRawData.GetData(), InRawData.Num()) )
        {
            TArray64<uint8>* RawData = new TArray64<uint8>();
            if ( ImageWrapper->GetRaw(ERGBFormat::BGRA, 8, *RawData) )
            {
                if (     UTexture2D* Texture = UTexture2D::CreateTransient(ImageWrapper->GetWidth(), ImageWrapper->GetHeight()) )
                {
                    const TArray64<uint8>& PNGData = ImageWrapper->GetCompressed(100);
                    // Save to Disk. App invitation QR Image.
                    FString SavedInvitationImage = FPaths::Combine(*FPaths::ProjectDir(), *InvitationImageName);
#if PLATFORM_ANDROID
                    extern FString GExternalFilePath;
                    //                    if(FAndroidMisc::GetAndroidBuildVersion() < 26) {
                    // if bUseExternalFilesDir == true
                    SavedInvitationImage = FPaths::Combine(*GExternalFilePath, *InvitationImageName);
                    //                    }
#endif
                    bool bSavedLocal = FFileHelper::SaveArrayToFile( PNGData, *SavedInvitationImage );
                    if (bSavedLocal)
                    {
                        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("Promotion RawDataToBrush request complete. Local file saved =%s"),
                                                                                         *SavedInvitationImage);
                    }
                    else
                    {
                        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("Promotion RawDataToBrush request complete. Local file failed to save =%s"),
                                                                                         *SavedInvitationImage);
                    }
                    // Save to Memory Texture..
                    WriteRawToTexture(Texture, RawData);
                    return Texture;
                }
            }
        }
    }
    
    //empty Texture.
    UTexture2D* Texture = UTexture2D::CreateTransient(1, 1);
    
    return Texture;
}

void PrintFHiveAppInvitationData(const FHiveAppInvitationData& AppInvitationData)
{
    FString Message = TEXT("[FHiveAppInvitationData]\n");
    Message += FString::Printf(TEXT("InviteCommonLink = %s\n"), *(AppInvitationData.InviteCommonLink));
    Message += FString::Printf(TEXT("InviteHiveMsgLink = %s\n"), *(AppInvitationData.InviteHiveMsgLink));
    Message += FString::Printf(TEXT("InviteFacebookLink = %s\n"), *(AppInvitationData.InviteFacebookLink));
    
    Message += FString::Printf(TEXT("  [EachCampaignList]\n"));
    for (const auto& EachCampaign: AppInvitationData.EachCampaignList)
    {
        // FJsonObject를 문자열로 직렬화
        FString ItemString;
        TSharedRef<TJsonWriter<>> JsonWriter = TJsonWriterFactory<>::Create(&ItemString);
        FJsonSerializer::Serialize(EachCampaign.Item.ToSharedRef(), JsonWriter);
        
        Message += FString::Printf(TEXT("  Title = %s, Description= %s, ImageUrl = %s, Order = %d, Item = %s, Count = %d, Limit = %d, CampaignId = %s\n"),
                                   *(EachCampaign.Title),
                                   *(EachCampaign.Description),
                                   *(EachCampaign.ImageUrl),
                                   EachCampaign.Order,
                                   *ItemString,
                                   EachCampaign.Count,
                                   EachCampaign.Limit,
                                   *(EachCampaign.CampaignId)
                                   );
    }
    
    Message += FString::Printf(TEXT("  [StageCampaignList]\n"));
    for (const auto& StageCampaign: AppInvitationData.StageCampaignList)
    {
        // FJsonObject를 문자열로 직렬화
        FString ItemString;
        TSharedRef<TJsonWriter<>> JsonWriter = TJsonWriterFactory<>::Create(&ItemString);
        FJsonSerializer::Serialize(StageCampaign.Item.ToSharedRef(), JsonWriter);
        
        Message += FString::Printf(TEXT("  Title = %s, Description= %s, ImageUrl = %s, Order = %d, Item = %s, Count = %d, Limit = %d, CampaignId = %s, GoalCount = %d, GoalTotal = %d\n"),
                                   *(StageCampaign.Title),
                                   *(StageCampaign.Description),
                                   *(StageCampaign.ImageUrl),
                                   StageCampaign.Order,
                                   *ItemString,
                                   StageCampaign.Count,
                                   StageCampaign.Limit,
                                   *(StageCampaign.CampaignId),
                                   StageCampaign.GoalCount,
                                   StageCampaign.GoalTotal
                                   );
    }
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("%s"), *(Message));
}

void UPromotionTestView::PromotionGetInvitationData()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("=== GetAppInvitationData() ==="));
    FHivePromotion::GetAppInvitationData(FHivePromotionOnAppInvitationDataDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveAppInvitationData& AppInvitationData) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("Result = %s"), *(Result.ToString()));
        
        if (Result.IsSuccess())
        {
            PrintFHiveAppInvitationData(AppInvitationData);
            
            testPromotionInvitation.CommonLink = AppInvitationData.InviteCommonLink;
            testPromotionInvitation.HiveLink = AppInvitationData.InviteHiveMsgLink;
            testPromotionInvitation.FacebookLink = AppInvitationData.InviteFacebookLink;
            testPromotionInvitation.QRcodeImg = RawDataToBrush(AppInvitationData.QrCodes);
            
            this->mAppInvitationData = AppInvitationData;
            
            if(OnUpdatePromotionInvitation.IsBound())
            {
                AsyncTask(ENamedThreads::GameThread, [this]() {
                    OnUpdatePromotionInvitation.Broadcast();
                });
            }
        }
        
    }));
}

void UPromotionTestView::PromotionShareInvitationImage()
{
	FString SavedInvitationImage = PromotionGetShareMediaPath();
	//	std::vector<std::string> imagePath;
	//    imagePath.push_back(std::string((TCHAR_TO_UTF8(*SavedInvitationImage))));
		//	IPlatformFile& PlatformFile = FPlatformFileManager::Get().GetPlatformFile();
		//	if (!PlatformFile.FileExists(*SavedInvitationImage))
		//	{
		//		AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("PlatformHelper::shareMedia SavedInvitationImage EXIST" ));
		//	}
		//	AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("Try  PlatformHelper::shareMedia path : %s"), *SavedInvitationImage);
		//    PlatformHelper::shareMedia(imagePath, "QRCode Image Sharing\n", std::bind(&UPromotionTestView::exampleOnAppInvitationShare, this, std::placeholders::_1));
		std::string strPath(TCHAR_TO_UTF8(*SavedInvitationImage));
		hive::PlatformShare* platformShare = new hive::PlatformShare();
		platformShare->setShareType(hive::PlatformShareType::MEDIA);
		platformShare->setMedia({strPath});
		hive::PlatformHelper::share(*platformShare, [=, this](bool isSuccess){
			AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("PlatformHelper::share Media isSuccess? %s"), isSuccess ? TEXT("TRUE"):TEXT("FALSE") );
		});
}

void UPromotionTestView::PromotionShareInvitationDataURL(FString URL)
{
	FString shareText = URL + TEXT("\nInvite link share\n");
		//    PlatformHelper::shareText(std::string((TCHAR_TO_UTF8(*shareText))),  std::bind(&UPromotionTestView::exampleOnAppInvitationShare, this, std::placeholders::_1));
		std::string strText(TCHAR_TO_UTF8(*shareText));
		hive::PlatformShare* platformShare = new hive::PlatformShare();
		platformShare->setShareType(hive::PlatformShareType::TEXT);
		platformShare->setText("Sharing : "+ strText);
		PlatformHelper::share(*platformShare, [=, this](bool isSuccess){
			AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("PlatformHelper::share Text isSuccess? %s"), isSuccess ? TEXT("TRUE"):TEXT("FALSE") );
		});
	//    std::vector<std::string> urlPath;
	//    urlPath.push_back(std::string((TCHAR_TO_UTF8(*URL))));
	//    PlatformHelper::shareMedia(urlPath, "Invite link share\n", std::bind(&UPromotionTestView::exampleOnAppInvitationShare, this, std::placeholders::_1));
}


void UPromotionTestView::PromotionShareText(FString text)
{
	std::string strText(TCHAR_TO_UTF8(*text));
	hive::PlatformShare* platformShare = new hive::PlatformShare();
	platformShare->setShareType(hive::PlatformShareType::TEXT);
	platformShare->setText("Sharing : "+ strText);
	hive::PlatformHelper::share(*platformShare, [=, this](bool isSuccess){
		AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("PlatformHelper::share Text isSuccess? %s"), isSuccess ? TEXT("TRUE"):TEXT("FALSE") );
	});
}


void UPromotionTestView::PromotionShareMedia(FString path)
{
	std::string strPath(TCHAR_TO_UTF8(*path));
	hive::PlatformShare* platformShare = new hive::PlatformShare();
	platformShare->setShareType(hive::PlatformShareType::MEDIA);
	platformShare->setMedia({strPath});
	hive::PlatformHelper::share(*platformShare, [=, this](bool isSuccess){
		AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("PlatformHelper::share Media isSuccess? %s"), isSuccess ? TEXT("TRUE"):TEXT("FALSE") );
	});
}

FString UPromotionTestView::PromotionGetShareMediaPath()
{
	FString destinationPath = FPaths::Combine(*FPaths::ProjectDir(), *InvitationImageName);
#if PLATFORM_ANDROID
	extern FString GExternalFilePath;
    FString lAppid = FHiveConfiguration::GetAppId();
	FString BasePath;
	if(FAndroidMisc::GetAndroidBuildVersion() >= 26)
	{
		// below code problem on Android 9.0
		//        BasePath = TEXT("content://") + lAppid + TEXT(".provider/external_files/Android/data/") + lAppid + TEXT("/files/UE4Game/") + FApp::GetProjectName() + TEXT("/") + FApp::GetProjectName();
		//		BasePath = TEXT("content://") + lAppid + TEXT(".provider/external_files/UE4Game/") + FApp::GetProjectName() + TEXT("/") + FApp::GetProjectName();
		
		// if bUseExternalFilesDir == true
		BasePath = TEXT("content://") + lAppid + TEXT(".provider/external_files/Android/data/") + lAppid + TEXT("/files");
	}
	else
	{
		BasePath = TEXT("file://") + GExternalFilePath;// + TEXT("/UE4Game/") + FApp::GetProjectName() + TEXT("/") + FApp::GetProjectName();
	}
	destinationPath = FPaths::ConvertRelativePathToFull(BasePath, InvitationImageName);
#elif PLATFORM_IOS
	FString Result = destinationPath;
	Result.ReplaceInline(TEXT("../"), TEXT(""));
	Result.ReplaceInline(TEXT(".."), TEXT(""));
	Result.ReplaceInline(FPlatformProcess::BaseDir(), TEXT(""));
	FString WritePathBase = FString([NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0]) + TEXT("/");
	destinationPath = WritePathBase + Result;
#endif
	
	return destinationPath;
}


void UPromotionTestView::PromotionShowUAShare()
{
    FString InviteMessage = this->mAppInvitationData.InviteMessage;
    FString InviteLink = this->mAppInvitationData.InviteHiveMsgLink;
    FHivePromotion::ShowUAShare(InviteMessage, InviteLink, FHivePromotionOnUAShareDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("=== ShowUAShare() ===\nResult = %s"), *(Result.ToString()));
    }));
}

TArray< uint8 > makeUintArrayFromFString(FString srcString)
{
	TArray<uint8> rtnData;
	// De-hex string into TArray<uint8>
	const int32 DataLength = srcString.Len() / 2;
	rtnData.Reset( DataLength );
	rtnData.AddUninitialized( DataLength );
	FString::ToHexBlob( srcString, rtnData.GetData(), DataLength );
	//    FString::ToBlob( srcString, rtnData.GetData(), DataLength );
	return rtnData;
}

void UPromotionTestView::PromotionSetAdditionalInfo(FString strAdditionalInfo)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("=== SetAdditionalInfo() ===\nAdditionalinfo = %s"), *strAdditionalInfo);
	FHivePromotion::SetAdditionalInfo(strAdditionalInfo);
}

void PrintFHivePromotionBannerInfo(const FHivePromotionBannerInfo& BannerInfo)
{
    FString Message = TEXT("FHivePromotionBannerInfo\n");
    Message += FString::Printf(TEXT("pid = %d\n"), BannerInfo.Pid);
    Message += FString::Printf(TEXT("ImageUrl = %s\n"), *(BannerInfo.ImageUrl));
    Message += FString::Printf(TEXT("LinkUrl = %s\n"), *(BannerInfo.LinkUrl));
    Message += FString::Printf(TEXT("DisplayStartDate = %s\n"), *(BannerInfo.DisplayStartDate));
    Message += FString::Printf(TEXT("DisplayEndDate = %s\n"), *(BannerInfo.DisplayEndDate));
    Message += FString::Printf(TEXT("UtcStartDate = %lld\n"), BannerInfo.UtcStartDate);
    Message += FString::Printf(TEXT("UtcEndDate = %lld\n"), BannerInfo.UtcEndDate);
    Message += FString::Printf(TEXT("TypeLink = %s\n"), *(BannerInfo.TypeLink));
    Message += FString::Printf(TEXT("TypeBanner = %s\n"), *(BannerInfo.TypeBanner));
    Message += FString::Printf(TEXT("TypeCampaign = %s\n"), *(BannerInfo.TypeCampaign));
    Message += FString::Printf(TEXT("InterworkData = %s\n"), *(BannerInfo.InterworkData));
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("%s"), *(Message));
}

void UPromotionTestView::PromotionGetBannerInfo(FString campType, FString bannerType) {
    
    EHivePromotionCampaignType CampaignType = GetEHivePromotionCampaignTypeFromName(campType);
    EHivePromotionBannerType BannerType = GetEHivePromotionBannerTypeFromName(bannerType);
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("=== GetBannerInfo(%s, %s) ==="),
                                                                     *(GetNameFromEHivePromotionCampaignType(CampaignType)),
                                                                     *(GetNameFromEHivePromotionBannerType(BannerType)));
    FHivePromotion::GetBannerInfo(CampaignType, BannerType, FHivePromotionOnBannerInfoDelegate::CreateLambda([this](const FHiveResultAPI& Result, const TArray<FHivePromotionBannerInfo>& PromotionBannerInfoList) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("Result = %s"), *(Result.ToString()));
        
        if (!Result.IsSuccess()) return;
        
        TArray<FTestPromotionRollingBannerInfo> rollingBannerLists;
        for(const auto& BannerInfo : PromotionBannerInfoList)
        {
            PrintFHivePromotionBannerInfo(BannerInfo);
            
            FTestPromotionRollingBannerInfo rBannerInfo;
            rBannerInfo.pid = BannerInfo.Pid;
            rBannerInfo.imageUrl = BannerInfo.ImageUrl;
            rBannerInfo.linkUrl = BannerInfo.LinkUrl;
            rBannerInfo.displayStartDate = BannerInfo.DisplayStartDate;
            rBannerInfo.displayEndDate = BannerInfo.DisplayEndDate;
            rBannerInfo.utcStartDate = BannerInfo.UtcStartDate;
            rBannerInfo.utcEndDate = BannerInfo.UtcEndDate;
            rBannerInfo.typeLink = BannerInfo.TypeLink;
            rBannerInfo.typeBanner = BannerInfo.TypeBanner;
            rBannerInfo.typeCampaign = BannerInfo.TypeCampaign;
            rBannerInfo.interworkData = BannerInfo.InterworkData;
            rollingBannerLists.Add(rBannerInfo);
        }
        testPromotionRollingBannerList = rollingBannerLists;
        
        if(OnGetBannerInfo.IsBound())
        {
            AsyncTask(ENamedThreads::GameThread, [this]() {
                OnGetBannerInfo.Broadcast();
            });
        }
    }));
}

void UPromotionTestView::PromotionGetBannerInfoString(FString campType, FString bannerType) {
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("=== GetBannerInfoString(%s, %s) ==="),
                                                                     *campType,
                                                                     *bannerType);
    FHivePromotion::GetBannerInfoString(campType, bannerType, FHivePromotionOnBannerInfoDelegate::CreateLambda([this](const FHiveResultAPI& Result, const TArray<FHivePromotionBannerInfo>& PromotionBannerInfoList) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("Result = %s"), *(Result.ToString()));
        
        if (!Result.IsSuccess()) return;
        
        TArray<FTestPromotionRollingBannerInfo> rollingBannerLists;
        for(const auto& BannerInfo : PromotionBannerInfoList)
        {
            PrintFHivePromotionBannerInfo(BannerInfo);
            
            FTestPromotionRollingBannerInfo rBannerInfo;
            rBannerInfo.pid = BannerInfo.Pid;
            rBannerInfo.imageUrl = BannerInfo.ImageUrl;
            rBannerInfo.linkUrl = BannerInfo.LinkUrl;
            rBannerInfo.displayStartDate = BannerInfo.DisplayStartDate;
            rBannerInfo.displayEndDate = BannerInfo.DisplayEndDate;
            rBannerInfo.utcStartDate = BannerInfo.UtcStartDate;
            rBannerInfo.utcEndDate = BannerInfo.UtcEndDate;
            rBannerInfo.typeLink = BannerInfo.TypeLink;
            rBannerInfo.typeBanner = BannerInfo.TypeBanner;
            rBannerInfo.typeCampaign = BannerInfo.TypeCampaign;
            rBannerInfo.interworkData = BannerInfo.InterworkData;
            rollingBannerLists.Add(rBannerInfo);
        }
        testPromotionRollingBannerList = rollingBannerLists;
        
        if(OnGetBannerInfo.IsBound())
        {
            AsyncTask(ENamedThreads::GameThread, [this]() {
                OnGetBannerInfo.Broadcast();
            });
        }
    }));
}

void UPromotionTestView::PromotionProcessBannerButton(int pid, FString interworkData) {
    
    FString ContentsKey = FString::FromInt(pid);
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== Clicked BannerButton =="));
    FHivePromotion::ShowCustomContents(EHivePromotionCustomType::DIRECT, ContentsKey, FHivePromotionViewDelegate::CreateLambda([this](const FHiveResultAPI& ResultAPI, const EHivePromotionEventType& PromotionEventType) {
        PrintPromotionViewDelegateResult(ResultAPI, PromotionEventType);
    }));
}

bool UPromotionTestView::PromotionProcessURI(FString uri) {
    bool result = FHivePromotion::ProcessURI(uri);
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion, TEXT("=== ProcessURI() ===\nResult = %s"), result ? TEXT("TRUE") : TEXT("FALSE"));
	return result;
}

void UPromotionTestView::ConfigurationUpdateServerID(FString serverId)
{
    FHiveConfiguration::UpdateServerId(serverId);
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("UpdateServerId(%s)\n"), *serverId);
    
    FString SavedConfigFile = FPaths::Combine(*FPaths::ProjectDir(), *FString("HIVESDKV4ConfigSaved.txt"));
    TSharedPtr<FJsonObject> arg = MakeShareable(new FJsonObject);
    arg->SetStringField(TEXT("serverId"), serverId);
    
    FString langCode = AHIVESDKV4TesterGameMode::getGameModeInstance()->modeStrLanguage;
    FString savedLanguage = GetSavedLanguage(langCode);
    arg->SetStringField(TEXT("gameLanguage"), savedLanguage);
    
    FString OutputString;
    TSharedRef< TJsonWriter<> > Writer = TJsonWriterFactory<>::Create(&OutputString);
    FJsonSerializer::Serialize(arg.ToSharedRef(), Writer);
    FFileHelper::SaveStringToFile(OutputString, *SavedConfigFile);
    
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->modeStrServerID = serverId;

}

void UPromotionTestView::ConfigurationUpdateGameLanguage(FString language)
{
    FHiveConfiguration::UpdateGameLanguage(language);
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("UpdateGameLanguage(%s)\n"), *language);
    
    FString savedLanguage = GetSavedLanguage(language);
    
    FString SavedConfigFile = FPaths::Combine(*FPaths::ProjectDir(), *FString("HIVESDKV4ConfigSaved.txt"));
    TSharedPtr<FJsonObject> arg = MakeShareable(new FJsonObject);
    arg->SetStringField(TEXT("gameLanguage"), savedLanguage);
    arg->SetStringField(TEXT("serverId"), AHIVESDKV4TesterGameMode::getGameModeInstance()->modeStrServerID);
    FString OutputString;
    TSharedRef< TJsonWriter<> > Writer = TJsonWriterFactory<>::Create(&OutputString);
    FJsonSerializer::Serialize(arg.ToSharedRef(), Writer);
    FFileHelper::SaveStringToFile(OutputString, *SavedConfigFile);
    
    AHIVESDKV4TesterGameMode::getGameModeInstance()->modeStrLanguage = language;
}

FString UPromotionTestView::GetSavedLanguage(FString langCode)
{
    FString LanuguageListArr[] = {
        TEXT("English,en"),
        TEXT("Deutsch,de"),
        TEXT("español,es"),
        TEXT("français,fr"),
        TEXT("Indonesia,id"),
        TEXT("italiano,it"),
        TEXT("日本語,ja"),
        TEXT("한국어,ko"),
        TEXT("português,pt"),
        TEXT("русский,ru"),
        TEXT("ไทย,th"),
        TEXT("Türkçe,tr"),
        TEXT("Tiếng Việt,vi"),
        TEXT("简体中文,zh-Hans"),
        TEXT("繁體中文,zh-Hant"),
        TEXT("아랍어,ar"),
        TEXT("Not set,null")
    };
    
    FString savedLanguage = TEXT("한국어,ko");
    for(FString lang: LanuguageListArr)
    {
        if(lang.Contains(*langCode, ESearchCase::CaseSensitive, ESearchDir::FromEnd)) {
            savedLanguage = lang;
            break;
        }
    }
    return savedLanguage;
}

void UPromotionTestView::PromotionUpdatePromotionData()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("=== UpdatePromotionData() ==="));
    FHivePromotion::UpdatePromotionData();
}

void UPromotionTestView::PromotionGetAppInvitationSenderInfo()
{
    FHivePromotion::GetAppInvitationSenderInfo(FHivePromotionOnAppInvitationSenderInfoDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FHiveAppInvitationSenderInfo& AppInvitationSenderInfo) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("=== GetAppInvitationSenderInfo() ===\nResult = %s"), *(Result.ToString()));
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion ,TEXT("AppInvitationSenderInfo.Vid = %s"), *(AppInvitationSenderInfo.Vid));
    }));
}

void UPromotionTestView::PrintPromotionViewDelegateResult(const FHiveResultAPI& ResultAPI, const EHivePromotionEventType& PromotionEventType)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Promotion,
                                                                     TEXT("Result = %sPromotionEventType = %s\n\n"),
                                                                     *(ResultAPI.ToString()),
                                                                     *(GetNameFromEHivePromotionEventType(PromotionEventType)));
}
