/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "HivePromotion.h"
#include "HiveConfiguration.h"

#include "UObject/Object.h"
#include "PromotionTestView.generated.h"


USTRUCT(BlueprintType)
struct FTestPromotionAppInvitation
{
	GENERATED_BODY()
public:
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	UTexture2D * QRcodeImg;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString CommonLink;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString HiveLink;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString FacebookLink;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	TArray<FString> eachCampaignList;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	TArray<FString> stageCampaignList;
};

USTRUCT(BlueprintType)
struct FTestPromotionRollingBannerInfo
{
	GENERATED_BODY()
public:
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	int32 pid;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString imageUrl;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString linkUrl;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString displayStartDate;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString displayEndDate;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	int32 utcStartDate;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	int32 utcEndDate;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString typeLink;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString typeBanner;
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString typeCampaign;
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FString interworkData;
};

/**
 *
 */
UCLASS(BlueprintType)
class HIVESDKV4TESTER_API UPromotionTestView : public UObject
{
	GENERATED_BODY()
	
public:	
	DECLARE_DYNAMIC_MULTICAST_DELEGATE(FPromotionNoParamDelegate);
	
	UPROPERTY(BlueprintAssignable)
	FPromotionNoParamDelegate OnUpdatePromotionInvitation;
	
	UPROPERTY(BlueprintAssignable)
	FPromotionNoParamDelegate OnGetBannerInfo;

	//App Invitation Info Struct
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	FTestPromotionAppInvitation testPromotionInvitation;
	
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    TArray<FTestPromotionRollingBannerInfo> testPromotionRollingBannerList;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite)
    FString fstrGiftPidList;

	//Promotion
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionPromo(FString promoType, bool isForced);
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionCustomView(FString strCustomType, FString strViewID);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PromotionCustomViewOnGameWindow(FString strCustomType, FString strViewID);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PromotionShowNews(FString menu, FString giftPidListString);
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PromotionRandomGiftPidList();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionGetOfferwallState();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionOfferwall();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionShowNativeReview();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PromotionShowReview();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionExit();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionGetViewInfo(FString strCustomType, FString strViewID);
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionGetBadgeInfo();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionGetInvitationData();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionShareInvitationImage();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionShareInvitationDataURL(FString URL);
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionSetAdditionalInfo(FString strAdditionalInfo);
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionShareText(FString text);
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionShareMedia(FString path);
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	FString PromotionGetShareMediaPath();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionShowUAShare();
	
	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionGetBannerInfo(FString campType, FString bannerType);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PromotionGetBannerInfoString(FString campType, FString bannerType);

	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	void PromotionProcessBannerButton(int pid, FString interworkData);

	UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
	bool PromotionProcessURI(FString uri);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void ConfigurationUpdateServerID(FString serverId);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void ConfigurationUpdateGameLanguage(FString language);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PromotionUpdatePromotionData();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4")
    void PromotionGetAppInvitationSenderInfo();
    
    FString GetSavedLanguage(FString langCode);
    
private:
    void PrintPromotionViewDelegateResult(const FHiveResultAPI& ResultAPI, const EHivePromotionEventType& PromotionEventType);
    
    FHiveAppInvitationData mAppInvitationData;
};
