/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "ProviderTestView.h"
#include "HIVESDKV4Tester.h"
#include "HIVESDKV4TesterGameMode.h"


UProviderTestView::UProviderTestView(const FObjectInitializer& ObjectInitializer)
: Super(ObjectInitializer)
{
}

void UProviderTestView::AppleReportScore(FString score, FString leaderboardID)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== ReportScore(%s, %s) ==="), *score, *leaderboardID);
    FHiveProviderApple::ReportScore(score, leaderboardID, FHiveProviderAppleOnReportLeaderboard::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));
}

void UProviderTestView::AppleShowLeaderboard()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== ShowLeaderboard() ==="));
    FHiveProviderApple::ShowLeaderboard(FHiveProviderAppleOnShowLeaderboard::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));

}

void UProviderTestView::AppleLoadAchievements()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== LoadAchievements() ==="));
    FHiveProviderApple::LoadAchievements(FHiveProviderAppleOnLoadAchievements::CreateLambda([this](const FHiveResultAPI& Result, const TArray<FHiveProviderAppleAchievement>& Achievements) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
        
        if (Result.IsSuccess())
        {
            for (const auto& Achievement : Achievements)
            {
                AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("Identifier = %s, Percent = %s, Completed = %s"),
                                                                                 *(Achievement.Identifier),
                                                                                 *(Achievement.Percent),
                                                                                 Achievement.Completed ? TEXT("TRUE") : TEXT("FALSE"));
            }
        }
    }));
}

void UProviderTestView::AppleReportAchievement(FString percent, bool showsCompletionBanner, FString achievementID)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== ReportAchievement() ==="));
    FHiveProviderApple::ReportAchievement(percent, showsCompletionBanner, achievementID, FHiveProviderAppleOnReportAchievement::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));
}

void UProviderTestView::AppleShowAchievements()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== ShowAchievements() ==="));
    FHiveProviderApple::ShowAchievements(FHiveProviderAppleOnShowAchievement::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));
}

void UProviderTestView::AppleResetAchievements()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== ResetAchievements() ==="));
    FHiveProviderApple::ResetAchievements(FHiveProviderAppleOnResetAchievement::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));
}

void UProviderTestView::GoogleAchievementsReveal(FString achievementId)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== AchievementsReveal(%s) ==="), *achievementId);
    
    FHiveProviderGoogle::AchievementsReveal(achievementId, FHiveProviderGoogleOnAchievementsDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));
}

void UProviderTestView::GoogleAchievementsUnlock(FString achievementId)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== AchievementsUnlock(%s) ==="), *achievementId);
    
    FHiveProviderGoogle::AchievementsUnlock(achievementId, FHiveProviderGoogleOnAchievementsDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));
}

void UProviderTestView::GoogleAchievementsIncrement(FString achievementId, FString value)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== AchievementsIncrement(%s, %s) ==="), *achievementId, *value);
    
    int iValue = FCString::Atoi(*value);
    FHiveProviderGoogle::AchievementsIncrement(achievementId, iValue, FHiveProviderGoogleOnAchievementsDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));
}

void UProviderTestView::GoogleLeaderboardsSubmitScore(FString leaderboardId, FString score)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== LeaderboardsSubmitScore(%s, %s) ==="), *leaderboardId, *score);
    
    int iScore = FCString::Atoi(*score);
    FHiveProviderGoogle::LeaderboardsSubmitScore(leaderboardId, iScore, FHiveProviderGoogleOnLeaderboardsDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));
}

void UProviderTestView::GoogleShowLeaderboard()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== ShowLeaderboard() ==="));
    
    FHiveProviderGoogle::ShowLeaderboard(FHiveProviderGoogleOnLeaderboardsDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));
}

void UProviderTestView::GoogleShowAchievements()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== ShowAchievements() ==="));
    
    FHiveProviderGoogle::ShowAchievements(FHiveProviderGoogleOnLeaderboardsDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s"), *(Result.ToString()));
    }));
}

void UProviderTestView::GoogleGetPlayerId()
{
	AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("=== GetGooglePlayerId() ==="));
    FHiveProviderGoogle::GetGooglePlayerId(FHiveProviderGoogleOnGooglePlayerIdDelegate::CreateLambda([this](const FHiveResultAPI& Result, const FString& GooglePlayerId, const FString& AuthCode) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::Provider, TEXT("%s\nGooglePlayerId = %s\nAuthCode = %s"), *(Result.ToString()), *GooglePlayerId, *AuthCode);
    }));
}
