/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "HiveProviderGoogle.h"
#include "HiveProviderApple.h"

#include "ProviderTestView.generated.h"

UCLASS(BlueprintType)
class HIVESDKV4TESTER_API UProviderTestView : public UObject
{
    GENERATED_UCLASS_BODY()

public:

    //Apple
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Apple")
    void AppleReportScore(FString score, FString leaderboardID);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Apple")
    void AppleShowLeaderboard();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Apple")
    void AppleLoadAchievements();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Apple")
    void AppleReportAchievement(FString percent, bool showsCompletionBanner, FString achievementID);

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Apple")
    void AppleShowAchievements();
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Apple")
    void AppleResetAchievements();
    
    //Google
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Google")
    void GoogleAchievementsReveal(FString achievementId);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Google")
    void GoogleAchievementsUnlock(FString achievementId);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Google")
    void GoogleAchievementsIncrement(FString achievementId, FString value);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Google")
    void GoogleLeaderboardsSubmitScore(FString leaderboardId, FString score);
    
    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Google")
    void GoogleShowLeaderboard();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Google")
    void GoogleShowAchievements();

    UFUNCTION(BlueprintCallable,Category="HIVE SDK V4|Provider|Google")
	void GoogleGetPlayerId();
};
