//
//  SocialV4TestView.cpp
//  HIVESDKV4Tester_Index
//
//  Created by disker on 2021/11/15.
//  Copyright © 2021 Epic Games, Inc. All rights reserved.
//

#include "SocialV4TestView.h"
#include "HIVESDKV4Tester.h"
#include "HIVESDKV4TesterGameMode.h"

void USocialV4TestView::SocialV4ShowCommunity(FString viewType)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::SocialV4, TEXT("=== ShowCommunity(HIVE, %s) ==="), *(viewType));
    
    ESocialV4ViewType ViewType = ESocialV4ViewType::FullScreen;
    if(viewType.Equals(TEXT("Frame")))
    {
        ViewType = ESocialV4ViewType::Frame;
    }
    
    FHiveSocialV4::ShowCommunity(ESocialV4ProviderType::HIVE, ViewType, FHiveSocialV4OnShowCommunityDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::SocialV4, TEXT("%s"), *(Result.ToString()));
    }));
}

void USocialV4TestView::SocialV4SharePhoto()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::SocialV4, TEXT("=== SharePhoto(FACEBOOK) ==="));
    FHiveSocialV4::SharePhoto(ESocialV4ProviderType::FACEBOOK, FHiveSocialV4OnSharePhotoDelegate::CreateLambda([this](const FHiveResultAPI& Result) {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::SocialV4, TEXT("%s"), *(Result.ToString()));
    }));
}
