/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "Http.h"
#include "PostBoxItemConsumable.h"
#include "HiveConfiguration.h"
#include "HiveAuthV4.h"

class UPostBoxItemConsumable;

struct ITestAppGameNetworkResponse
{
    FString resultCode;
    FString resultMsg;
    TSharedPtr<FJsonObject> resultData;
    FString sessionToken;
    FString authKey;
};

class HIVESDKV4TESTER_API TestAppGameNetwork
{
public:
    DECLARE_DELEGATE_TwoParams(FGameListener, bool, ITestAppGameNetworkResponse);

    TestAppGameNetwork() = default;
	~TestAppGameNetwork() = default;
    
    static void login(FGameListener listener);
    static void customAuth(FString idpId, FString idpUserId, FString authType, FGameListener listener);
    static void posts(FGameListener listener);
    static void postReceive(FGameListener listener, TArray<UPostBoxItemConsumable*> posts);
	static void verifyReceipt(FGameListener listener, FString bypassReceipt);
    static void verifyReceipt(FGameListener listener, FString bypassReceipt, FString itemType);
    static void verifyReceiptWithLogin(FGameListener listener, FString bypassReceipt);

private:
    static FString GetUrl(FString Path);
    static void request(FString url, TSharedPtr<FJsonObject> postData, FGameListener listener);
    static void request(FString url, TSharedPtr<FJsonObject> postData, FString contentType, FGameListener listener);
    static void connectionDidFinishLoading(FHttpRequestPtr Request, FHttpResponsePtr Response, bool bWasSuccessful);
};
