#pragma once

#include "TestAppGameNetwork.h"
#include "CoreMinimal.h"
#include "Subsystems/GameInstanceSubsystem.h"
#include "TestAppUserGameInstance.generated.h"

UCLASS()
class HIVESDKV4TESTER_API UTestAppUserGameInstance : public UGameInstanceSubsystem
{
    GENERATED_BODY()

public:
    virtual void Initialize(FSubsystemCollectionBase& Collection) override;
    virtual void Deinitialize() override;

    // 싱글턴 스타일 접근자
    UFUNCTION(BlueprintCallable, Category="HIVE SDK V4|PostBox", meta=(WorldContext="WorldContextObject"))
    static UTestAppUserGameInstance* GetInstance(const UObject* WorldContextObject);

    // 게임 유저 데이터
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="HIVE SDK V4|PostBox")
    FString sessionToken;
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="HIVE SDK V4|PostBox")
    FString nickname;
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="HIVE SDK V4|PostBox")
    FString serverID;
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="HIVE SDK V4|PostBox")
    int gold;
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="HIVE SDK V4|PostBox")
    int gem;
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="HIVE SDK V4|PostBox")
    bool isLogin = false;
    
    // 게임 유저 기능
    UFUNCTION(BlueprintCallable, Category="HIVE SDK V4|PostBox")
    void login();
    UFUNCTION(BlueprintCallable, Category="HIVE SDK V4|PostBox")
    void logout();
    UFUNCTION(BlueprintCallable, Category="HIVE SDK V4|PostBox")
    void update();

    void loginWithCallback(TFunction<void(bool, ITestAppGameNetworkResponse)> callback);
    
    TestAppGameNetwork::FGameListener updateListener;

private:
    void gameUpdateListener(bool result, ITestAppGameNetworkResponse response);
};