/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

using UnrealBuildTool;
using System.Collections.Generic;

public class HIVESDKV4TesterEditorTarget : TargetRules
{
    public HIVESDKV4TesterEditorTarget(TargetInfo Target) : base(Target)
    {
        Type = TargetType.Editor;
        #if UE_5_3_OR_LATER
            DefaultBuildSettings = BuildSettingsVersion.Latest;
            IncludeOrderVersion = EngineIncludeOrderVersion.Latest;
        #endif

        ExtraModuleNames.AddRange(new string[] { "HIVESDKV4Tester" });
        
        // iOS에 대한 ANSI 할당자 설정 - UE 5.6 새로운 방식
        if(Target.Platform == UnrealTargetPlatform.IOS)
        {
            // 이전 방식 제거
            // GlobalDefinitions.Add("FORCE_ANSI_ALLOCATOR=1");
            
            // UE 5.6 새로운 방식
            StaticAllocator = StaticAllocatorType.Ansi;
        }
        
        if (Target.Platform != UnrealTargetPlatform.Win64)
        {
            bOverrideBuildEnvironment = true;
            AdditionalCompilerArguments = "-Wno-unused-but-set-variable -Wno-shadow";
        }
    }
}