﻿/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */

using UnrealBuildTool;

public class HiveSDKManager : ModuleRules
{
	public HiveSDKManager(ReadOnlyTargetRules Target) : base(Target)
	{
		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;
		
		PublicIncludePaths.AddRange(
			new string[] {
                ModuleDirectory + "/Public",
                ModuleDirectory + "/Public/Protocol",
                ModuleDirectory + "/Public/IgnorePatchFile"
            }
			);
				
		
		PrivateIncludePaths.AddRange(
			new string[] {
                ModuleDirectory + "/Private",
                ModuleDirectory + "/Private/Protocol",
                ModuleDirectory + "/Private/IgnorePatchFile"
            }
			);
			
		
		PublicDependencyModuleNames.AddRange(
			new string[]
			{
				"Core",
				// ... add other public dependencies that you statically link with here ...
			}
			);
			
		
		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
				"CoreUObject",
				"Engine",
				"Slate",
				"SlateCore",
				// ... add private dependencies that you statically link with here ...	
			}
			);
		
		
		DynamicallyLoadedModuleNames.AddRange(
			new string[]
			{
				// ... add any modules that your module loads dynamically here ...
			}
			);

        if (Target.Type == TargetRules.TargetType.Editor)
        {
            PrivateDependencyModuleNames.AddRange(
				new string[]
				{
                    "EditorSubsystem",
                    "UnrealEd", // for Editor Subsystem
					"Json",
                    "JsonUtilities",
                    "HTTP",
                    "FileUtilities"

                }
			);
        }
    }
}
