/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */

#include "HiveManagerIgnorePatchFile.h"

FHiveManagerIgnorePatchFile::FHiveManagerIgnorePatchFile(bool bInIsCaseSensitive)
	: bIsCaseSensitive(bInIsCaseSensitive)
{
}

FHiveManagerIgnorePatchFile::FHiveManagerIgnorePatchFile(const FString& InIgnoreFile, bool bInIsCaseSensitive)
	: bIsCaseSensitive(bInIsCaseSensitive)
	, FileName(InIgnoreFile)
{
}

FString FHiveManagerIgnorePatchFile::GetRemoveCommentAndTrim(const FString& Message) const
{
	FString Trimmed = Message.TrimStartAndEnd();
	int32 Index = Trimmed.Find(TEXT("#"));

	if (Index != INDEX_NONE)
	{
		return Trimmed.Left(Index).TrimStartAndEnd();
	}

	return Trimmed;
}

FString FHiveManagerIgnorePatchFile::PathStandard(const FString& Path) const
{
	FString StandardPath = FPaths::ConvertRelativePathToFull(Path);

	if (!bIsCaseSensitive)
	{
		StandardPath = StandardPath.ToLower();
	}

	return StandardPath;
}

void FHiveManagerIgnorePatchFile::InsertIgnorePath(const FString& Ignore)
{
	PathTree.Insert(PathStandard(Ignore));
}

void FHiveManagerIgnorePatchFile::Parse()
{
	if (FPaths::FileExists(FileName))
	{
		TArray<FString> IgnoreList;
		TArray<FString> Lines;

		if (FFileHelper::LoadFileToStringArray(Lines, *FileName))
		{
			for (const FString& Line : Lines)
			{
				// #부터는 주석으로 처리함
				FString CommentRemovedLine = GetRemoveCommentAndTrim(Line);

				if (!CommentRemovedLine.IsEmpty())
				{
					FString Path = PathStandard(CommentRemovedLine);
					IgnoreList.Add(Path);
				}
			}
		}

		IgnoreList.Sort();

		for (int32 i = 0; i < IgnoreList.Num(); ++i)
		{
			PathTree.Insert(IgnoreList[i]);
		}
	}
}

bool FHiveManagerIgnorePatchFile::IsIgnore(const FString& Path) const
{
	return PathTree.IsIgnore(PathStandard(Path));
}