/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */
#pragma once

#include "CoreMinimal.h"

DECLARE_LOG_CATEGORY_EXTERN(HIVE_MANAGER_LOG, Log, All);

#define LOG_CALLINFO (FString::Printf(TEXT("%s (line: %d)"), ANSI_TO_TCHAR(__FUNCTION__), __LINE__)) // ex. Setup (line: 27)

#define HM_LOG(Format, ...) UE_LOG(HIVE_MANAGER_LOG, Log, TEXT("%s %s"), *LOG_CALLINFO, *FString::Printf(Format, ##__VA_ARGS__)) // ex. HIVE_MANAGER_LOG: Warning: Setup (line: 27) Message

#define HM_LOG_WARNING(Format, ...) UE_LOG(HIVE_MANAGER_LOG, Warning, TEXT("%s %s"), *LOG_CALLINFO, *FString::Printf(Format, ##__VA_ARGS__)) // ex. HIVE_MANAGER_LOG: Warning: Setup (line: 27) Message

#define HM_LOG_ERROR(Format, ...) UE_LOG(HIVE_MANAGER_LOG, Error, TEXT("%s %s"), *LOG_CALLINFO, *FString::Printf(Format, ##__VA_ARGS__)) // ex. HIVE_MANAGER_LOG: Error: Setup (line: 27) Message