/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */
#include "Models/UpdateListViewModel.h"

void UManagerInterfaceInfoWrapper::Initialize(const FManagerInterfaceInfo& Info)
{
    Engine = Info.Engine;
    Version = Info.Version;
    State = Info.State;
    ReleaseNoteUrl = Info.ReleaseNoteUrl;
    DeployDate = Info.DeployDate;
    DownloadUrl = Info.DownloadUrl;
}

UUpdateListViewSubItem::UUpdateListViewSubItem()
{
}

void UUpdateListViewSubItem::Initialize(
    const FString& InType,
    const FString& InCurrentVersion,
    const TArray<FString>& InAvailableVersions)
{
    Type = InType;
    CurrentVersion = InCurrentVersion;
    AvailableVersions = InAvailableVersions;

    if (!InAvailableVersions.IsEmpty())
    {
        SelectedVersion = AvailableVersions[0];
    }

    bChecked = false;
}

UUpdateListViewItem::UUpdateListViewItem()
    : InterfaceInfo(nullptr)
    , Android(nullptr)
    , iOS(nullptr)
    , Mac(nullptr)
    , Windows(nullptr)
{
}

void UUpdateListViewItem::Initialize(UManagerInterfaceInfoWrapper* InInterfaceInfo,
    const TArray<FString>& InAndroid,
    const TArray<FString>& InIOS,
    const TArray<FString>& InMac,
    const TArray<FString>& InWindows,
    const TMap<FString, FString>& InCurrentVersion)
{
    InterfaceInfo = InInterfaceInfo;

    if (!InAndroid.IsEmpty())
    {
        Android = NewObject<UUpdateListViewSubItem>(this);
        Android->Initialize(TEXT("Android"), InCurrentVersion.FindRef("Android"), InAndroid);
    }
    
    if (!InIOS.IsEmpty())
    {
        iOS = NewObject<UUpdateListViewSubItem>(this);
        iOS->Initialize(TEXT("iOS"), InCurrentVersion.FindRef("iOS"), InIOS);
    }

    if (!InMac.IsEmpty())
    {
        Mac = NewObject<UUpdateListViewSubItem>(this);
        Mac->Initialize(TEXT("Mac"), InCurrentVersion.FindRef("Mac"), InMac);
    }

    if (!InWindows.IsEmpty())
    {
        Windows = NewObject<UUpdateListViewSubItem>(this);
        Windows->Initialize(TEXT("Windows"), InCurrentVersion.FindRef("Windows"), InWindows);
    }

    CurrentVersion = InCurrentVersion;
}

void UUpdateListViewModel::Initialize(const TArray<UUpdateListViewItem*>& InItems, const TMap<FString, FString>& InCurrentVersion, const TMap<FString, FString>& InLatestVersion)
{
    Items = InItems;
    CurrentVersion = InCurrentVersion;
    LatestVersion = InLatestVersion;
}