/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */

#include "HiveManagerProtocolUrl.h"

const FString FHiveManagerProtocolUrl::ApiUrl = TEXT("https://sdk.withhive.com");
const FString FHiveManagerProtocolUrl::TestApiUrl = TEXT("https://dev-sdk.withhive.com");

FHiveManagerProtocolUrl::FHiveManagerProtocolUrl()
{
}

FHiveManagerProtocolUrl::~FHiveManagerProtocolUrl()
{
}

FString FHiveManagerProtocolUrl::Get(bool bIsTest)
{
	if (bIsTest)
	{
		return TestApiUrl;
	}
	else
	{
		return ApiUrl;
	}
}

FString FHiveManagerProtocolUrl::GetLegacy(bool bIsTest)
{
	if (bIsTest)
	{
		return TestApiUrl + TEXT("/v2/project");
	}
	else
	{
		return ApiUrl + TEXT("/v2/project");
	}
}

