﻿/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "CoreMinimal.h"
#include "Http.h"

DECLARE_DELEGATE_OneParam(FDownloadProgressDelegate, uint64 /* BytesReceived */);
DECLARE_DELEGATE_TwoParams(FDownloadCompleteDelegate, bool /*bSucceeded */, const FString& /*DownloadFilePath*/);
DECLARE_DELEGATE_TwoParams(FBackupPluginFilesCompleteDelegate, bool /*bAllSucceeded*/, const TArray<FString>& /*BackedUpFiles*/);

class HIVESDKMANAGER_API HiveManagerFile
{
public:
	
	static void DownloadFile(
		const FString& DownloadUrl,
		const FString& DownloadTargetPath,
		FDownloadProgressDelegate ProgressCallback,
		FDownloadCompleteDelegate CompleteCallback		
	);

	static bool UnZipp(const FString& Path, const FString& TargetPath);

	static FString GetHashFromFile(const FString& FilePath);

	static void BackupPluginFiles(const TArray<FString>& PluginFiles, const FString& DirName, FBackupPluginFilesCompleteDelegate OnComplete);
	static void RollbackPluginFiles(const TArray<FString>& PluginFiles, const FString& DirName);
};
