/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "CoreMinimal.h"
#include "HiveManagerIgnorePathTree.h"

class HIVESDKMANAGER_API FHiveManagerIgnorePatchFile
{
public:
	FHiveManagerIgnorePatchFile(bool bInIsCaseSensitive);
	FHiveManagerIgnorePatchFile(const FString& InIgnoreFile, bool bInIsCaseSensitive);

	void Parse();									// Ignore File 을 읽어 PathTree 객체 설정
	void InsertIgnorePath(const FString& Ignore);	// PathTree 객체에 Ignore 항목 추가
	bool IsIgnore(const FString& Path) const;		// Ignore 대상 여부 체크

private:
	bool bIsCaseSensitive;
	FHiveManagerPathTree PathTree;
	FString FileName;

	FString GetRemoveCommentAndTrim(const FString& Message) const;

	FString PathStandard(const FString& Path) const;
};