/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "CoreMinimal.h"
#include "HiveManagerIgnorePatchFile.h"

class HIVESDKMANAGER_API FHiveManagerIgnorePatchFileManager
{
public:
	// Singleton
	static FHiveManagerIgnorePatchFileManager& Get();

	void LoadIgnore();								// Ignore 설정 로드
	bool IsIgnore(const FString& Ignore) const;		// Ignore 여부 체크
	void EditIgnoreFile();							// Ignore 파일 편집
	TArray<FString> GetIgnoredFileNames();			// Ignore 목록 반환

private:
	FHiveManagerIgnorePatchFileManager();
	bool IsCaseSensitiveSystem() const;				// sensitive filesystem 체크

	FHiveManagerIgnorePatchFile IgnorePatchFile;    // 패치 제외 목록
	FHiveManagerIgnorePatchFile IgnoreFilter;       // 패치 제외 불가 목록(중요 파일)

	static const FString IgnoreFileName;			// Ignore 파일 이름 (HiveSDKManagerIgnore.txt)
	static const FString IgnoreFilePath;			// Ignore 파일 경로 (../Plugins/HiveSDKManager/HiveSDKManagerIgnore.txt)

	static const TArray<FString> ImportantFileList;	// 패치 제외 불가 목록 리스트
	static const FString CommentIgnoreFile;			// Ignore 파일 기본 주석
};
