/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "CoreMinimal.h"

class HIVESDKMANAGER_API FHiveManagerPathTree
{
public:
	FHiveManagerPathTree() = default;

	void Insert(const FString& Path);			// Ignore Path 추가
	bool IsIgnore(const FString& Path) const;	// Ignore Path 여부 체크

private:
	FString Data;
	TArray<FHiveManagerPathTree> Children;

	void Insert(const TArray<FString>& Paths, int32 CurrentIndex);
	bool IsIgnore(const TArray<FString>& Paths, int32 CurrentIndex) const;
	
	FString ChangePathWindowsToUnix(const FString& Path) const;
};