/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "CoreMinimal.h"
#include "HiveManagerStrings.generated.h"

UCLASS()
class HIVESDKMANAGER_API UHiveManagerStrings : public UObject
{
    GENERATED_BODY()

public:
    UHiveManagerStrings();

    void Initialize();

    // Returns the text that matches the current editor language
    UFUNCTION(BlueprintCallable, Category = "Hive|Localization")
    FString GetLocalizedText(const FString& Key) const;

private:
    // Stores localization data (Key -> (LanguageCode -> Text))
    TMap<FString, TMap<FString, FString>> LocalizationData;

    // Load from JSON file
    UFUNCTION(BlueprintCallable, Category = "Hive|Localization")
    bool LoadFromJsonFile(const FString& FilePath);

    // Load from JSON-String
    UFUNCTION(BlueprintCallable, Category = "Hive|Localization")
    bool LoadFromJsonString(const FString& JsonString);

    // Get the current editor language code(lowercase)
    FString GetCurrentEditorLanguage() const;
};
