﻿/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */
#pragma once

#include "CoreMinimal.h"
#include "Protocol/HiveManagerProtocolTypes.h"
#include "ManagerNoticeInfoViewModel.generated.h"

UCLASS(BlueprintType)
class HIVESDKMANAGER_API UManagerNoticeInfoViewModel : public UObject
{
    GENERATED_BODY()

public:
    UPROPERTY(BlueprintReadOnly, Category = "Notice")
    int32 NoticeId;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Notice Info")
    FString StartDate;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Notice Info")
    FString Title;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Notice Info")
    FString Details;

    static UManagerNoticeInfoViewModel* FromDomainModel(UObject* Outer, const FManagerNoticeInfo& DomainModel);
};