﻿/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */
#pragma once

#include "CoreMinimal.h"
#include "Protocol/HiveManagerProtocolTypes.h"
#include "UpdateListViewModel.generated.h"

UCLASS(BlueprintType)
class HIVESDKMANAGER_API UManagerInterfaceInfoWrapper : public UObject
{
    GENERATED_BODY()

public:
    UManagerInterfaceInfoWrapper() {};

    void Initialize(const FManagerInterfaceInfo& Info);

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    FString Engine;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    FString Version;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    int32 State;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    FString ReleaseNoteUrl;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    FString DeployDate;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    FString DownloadUrl;
};

UCLASS(BlueprintType)
class HIVESDKMANAGER_API UUpdateListViewSubItem : public UObject
{
    GENERATED_BODY()

public:
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    FString Type;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    FString CurrentVersion;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    TArray<FString> AvailableVersions;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    FString SelectedVersion;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    bool bChecked;

    UUpdateListViewSubItem();

    void Initialize(
        const FString& InType,
        const FString& InCurrentVersion,
        const TArray<FString>& InAvailableVersions);
};

UCLASS(BlueprintType)
class HIVESDKMANAGER_API UUpdateListViewItem : public UObject
{
    GENERATED_BODY()

public:

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    UManagerInterfaceInfoWrapper* InterfaceInfo;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    UUpdateListViewSubItem* Android;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    UUpdateListViewSubItem* iOS;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    UUpdateListViewSubItem* Mac;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    UUpdateListViewSubItem* Windows;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    TMap<FString, FString> CurrentVersion; // <Platform, Version>. 아이콘 처리 판단 값(적용됨, 업데이트 가능)

    

    UUpdateListViewItem();

    // 편의를 위한 초기화 함수
    void Initialize(UManagerInterfaceInfoWrapper* InInterfaceInfo,
        const TArray<FString>& InAndroid,
        const TArray<FString>& InIOS,
        const TArray<FString>& InMac,
        const TArray<FString>& InWindows,
        const TMap<FString, FString>& InCurrentVersion);
};

UCLASS(BlueprintType)
class HIVESDKMANAGER_API UUpdateListViewModel : public UObject
{
    GENERATED_BODY()

public:

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    TArray<UUpdateListViewItem*> Items;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    TMap<FString, FString> CurrentVersion; // <Platform, Version>
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Update")
    TMap<FString, FString> LatestVersion; // <Platform, Version>

    void Initialize(
        const TArray<UUpdateListViewItem*>& InItems,
        const TMap<FString, FString>& InCurrentVersion,
        const TMap<FString, FString>& InLatestVersion);
};
