/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "CoreMinimal.h"
#include "Json.h"
#include "JsonUtilities.h"

#include "HiveManagerProtocol.h"
#include "HiveManagerProtocolTypes.h"

class HIVESDKMANAGER_API FHiveManagerProtocolApi
{
public:
	FHiveManagerProtocolApi();
	~FHiveManagerProtocolApi();
	
	/* Interface */
	static void RequestInterfaceAll(FResponseCallback<TArray<FManagerInterfaceInfo>> Callback);
	static void RequestInterfaceDetail(const FString& Version, FResponseCallback<FManagerInterfaceDetailInfo> Callback);
	static void RequestInterfaceCompare(const FString& BaseVersion, const FString& CompareVersion, FResponseCallback<FManagerCompareInfo> Callback);

	/* Platform */
	static void RequestPlatformAll(const FString& Platform, FResponseCallback<TArray<FManagerPlatformInfo>> Callback);
	static void RequestPlatformDetail(const FString& Platform, const FString& Version, FResponseCallback<FManagerPlatformDetailInfo> Callback);
	static void RequestPlatformCompare(const FString& Platform, const FString& BaseVersion, const FString& CompareVersion, FResponseCallback<FManagerCompareInfo> Callback);
	// (NOT_SUPPORT) RequestPlatformAvailableAll(/platform/available/all)

	/* System */
	static void RequestNoticeInfo(FResponseCallback<TArray<FManagerNoticeInfo>> Callback);
	static void RequestManagerDownloadLogs(const FString& Type, const FString& DownloadVersion, FResponseCallback<FManagerEmptyResponse> Callback);
	static void RequestManagerServerState(FResponseCallback<FManagerEmptyResponse> Callback);

private:
	// Get the current editor language code(lowercase)
	static FString GetCurrentEditorLanguage();
	static FString GetHostOS();
	static FString GetCompanyName();
	static FString GetAppIdentifier();
};