/* Copyright © 2025-Present Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "CoreMinimal.h"
#include "HiveManagerProtocolTypes.generated.h"

/**
 * 
 */

USTRUCT()
struct FFile
{
	GENERATED_BODY()

	UPROPERTY()
	FString Path;

	UPROPERTY()
	FString FileHash;
};

USTRUCT()
struct FManagerEmptyResponse
{
	GENERATED_BODY()
};

USTRUCT()
struct FManagerInterfaceInfo
{
	GENERATED_BODY()

	UPROPERTY()
	FString Engine;

	UPROPERTY()
	FString Version;

	UPROPERTY()
	int32 State;

	UPROPERTY()
	FString ReleaseNoteUrl;

	UPROPERTY()
	FString DeployDate;

	UPROPERTY()
	FString DownloadUrl;
};

USTRUCT()
struct FManagerInterfaceDetailInfo : public FManagerInterfaceInfo
{
	GENERATED_BODY()

	UPROPERTY()
	TArray<FFile> Files;
};

USTRUCT()
struct FManagerPlatformInfo
{
	GENERATED_BODY()

	UPROPERTY()
	FString Engine;

	UPROPERTY()
	FString Platform;

	UPROPERTY()
	FString Version;

	UPROPERTY()
	int32 State;
};

USTRUCT()
struct FManagerPlatformDetailInfo : public FManagerPlatformInfo
{
	GENERATED_BODY()

	UPROPERTY()
	FString DownloadUrl;

	UPROPERTY()
	TArray<FFile> Files;
};


USTRUCT()
struct FManagerCompareInfo
{
	GENERATED_BODY()

	UPROPERTY()
	FString Engine;

	UPROPERTY()
	FString BaseVersion;

	UPROPERTY()
	FString CompareVersion;

	UPROPERTY()
	FString DownloadUrl;

	UPROPERTY()
	TArray<FFile> ModifyFiles;

	UPROPERTY()
	TArray<FFile> DeleteFiles;

	UPROPERTY()
	TArray<FFile> AddFiles;
};

USTRUCT()
struct FManagerNoticeInfo
{
	GENERATED_BODY()

	UPROPERTY()
	int32 NoticeId;

	UPROPERTY()
	FString StartDate;

	UPROPERTY()
	FString Title;

	UPROPERTY()
	FString Details;
};