/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mid.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.tencent.mid.api.MidEntity;
import com.tencent.mid.api.MidService;
import com.tencent.mid.b.g;
import com.tencent.mid.util.a;
import com.tencent.mid.util.h;
import com.tencent.mid.util.k;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpHost;
import org.json.JSONArray;
import org.json.JSONObject;

public class Util {
    public static void logInfo(String string) {
        if (MidService.isEnableDebug()) {
            Log.i((String)"MID", (String)string);
        }
    }

    public static void logWarn(Throwable throwable) {
        if (MidService.isEnableDebug()) {
            Log.w((String)"MID", (Throwable)throwable);
        }
    }

    public static boolean isStringValid(String string) {
        return string != null && string.trim().length() != 0;
    }

    public static String bytesToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    public static byte[] StringToBytes(String string) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public static boolean isMidValid(String string) {
        return string != null && string.trim().length() >= 40;
    }

    public static MidEntity getNewerMidEntity(MidEntity midEntity, MidEntity midEntity2) {
        if (midEntity != null && midEntity2 != null) {
            return midEntity.compairTo(midEntity2) >= 0 ? midEntity : midEntity2;
        }
        if (midEntity != null) {
            return midEntity;
        }
        if (midEntity2 != null) {
            return midEntity2;
        }
        return null;
    }

    public static void clear(Context context) {
        if (context == null) {
            return;
        }
        g.a(context).c();
    }

    public static boolean equal(MidEntity midEntity, MidEntity midEntity2) {
        if (midEntity != null && midEntity2 != null) {
            return midEntity.compairTo(midEntity2) == 0;
        }
        return midEntity == null && midEntity2 == null;
    }

    public static boolean checkPermission(Context context, String string) {
        boolean bl = false;
        try {
            PackageManager packageManager = context.getPackageManager();
            bl = packageManager.checkPermission(string, context.getPackageName()) == 0;
        }
        catch (Throwable throwable) {
            Log.e((String)"MID", (String)"checkPermission error", (Throwable)throwable);
        }
        return bl;
    }

    public static boolean isWifiNet(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getTypeName() != null && networkInfo.getTypeName().equalsIgnoreCase("WIFI");
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            ConnectivityManager connectivityManager;
            if (Util.checkPermission(context, "android.permission.INTERNET") && Util.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")) != null) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.isAvailable()) {
                    return true;
                }
                Log.w((String)"MID", (String)"Network error");
                return false;
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MID", (String)"isNetworkAvailable error", (Throwable)throwable);
        }
        return false;
    }

    public static String md5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuffer.append(byArray[i2]);
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Util.logWarn(noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Util.logWarn(unsupportedEncodingException);
        }
        return string;
    }

    public static void jsonPut(JSONObject jSONObject, String string, String string2) {
        if (Util.isStringValid(string2)) {
            jSONObject.put(string, (Object)string2);
        }
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 8) {
            return string;
        }
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = a.a(byArray, 0);
            byArray2 = h.b(byArray2);
            return new String(byArray2, "UTF-8").trim().replace("\t", "").replace("\n", "").replace("\r", "");
        }
        catch (Throwable throwable) {
            Log.e((String)"MID", (String)"decode error", (Throwable)throwable);
            return string;
        }
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 8) {
            return string;
        }
        try {
            byte[] byArray = h.a(string.getBytes("UTF-8"));
            byte[] byArray2 = a.b(byArray, 0);
            return new String(byArray2, "UTF-8").trim().replace("\t", "").replace("\n", "").replace("\r", "");
        }
        catch (Throwable throwable) {
            Log.w((String)"MID", (String)"encode error", (Throwable)throwable);
            return string;
        }
    }

    public static String getImei(Context context) {
        try {
            if (Util.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                String string = "";
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                string = telephonyManager.getDeviceId();
                if (string != null) {
                    return string;
                }
            } else {
                Util.logInfo("Could not get permission of android.permission.READ_PHONE_STATE");
            }
        }
        catch (Throwable throwable) {
            Util.logWarn(throwable);
        }
        return "";
    }

    public static String getWifiMacAddress(Context context) {
        if (Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            try {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager == null) {
                    return "";
                }
                return wifiManager.getConnectionInfo().getMacAddress();
            }
            catch (Exception exception) {
                Util.logInfo("get wifi address error" + exception);
                return "";
            }
        }
        Util.logInfo("Could not get permission of android.permission.ACCESS_WIFI_STATE");
        return "";
    }

    public static HttpHost getHttpProxy() {
        if (Proxy.getDefaultHost() != null) {
            return new HttpHost(Proxy.getDefaultHost(), Proxy.getDefaultPort());
        }
        return null;
    }

    public static HttpHost getHttpProxy(Context context) {
        if (null == context) {
            return null;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName()) != 0) {
                return null;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return null;
            }
            if (networkInfo.getTypeName() != null && networkInfo.getTypeName().equalsIgnoreCase("WIFI")) {
                return null;
            }
            String string = networkInfo.getExtraInfo();
            Util.logInfo("network type:" + string);
            if (string == null) {
                return null;
            }
            if (string.equals("cmwap") || string.equals("3gwap") || string.equals("uniwap")) {
                return new HttpHost("10.0.0.172", 80);
            }
            if (string.equals("ctwap")) {
                return new HttpHost("10.0.0.200", 80);
            }
            String string2 = Proxy.getDefaultHost();
            if (string2 != null && string2.trim().length() > 0) {
                int n = Proxy.getDefaultPort();
                return new HttpHost(string2, n);
            }
        }
        catch (Throwable throwable) {
            Util.logWarn(throwable);
        }
        return null;
    }

    public static byte[] deocdeGZipContent(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        int n = 0;
        while ((n = gZIPInputStream.read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        byteArrayInputStream.close();
        gZIPInputStream.close();
        byteArrayOutputStream.close();
        return byArray3;
    }

    public static String getHttpUrl() {
        return "http://pingmid.qq.com:80/";
    }

    public static byte[] getHMAC(String string, String string2) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(string.getBytes(), "hmacmd5");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKeySpec);
            mac.update(string2.getBytes());
            return mac.doFinal();
        }
        catch (Exception exception) {
            Util.logWarn(exception);
            return null;
        }
    }

    public static WifiInfo getWifiInfo(Context context) {
        Context context2;
        WifiManager wifiManager;
        if (Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE") && (wifiManager = (WifiManager)(context2 = context.getApplicationContext()).getSystemService("wifi")) != null) {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            return wifiInfo;
        }
        return null;
    }

    public static String getWiFiBBSID(Context context) {
        try {
            WifiInfo wifiInfo = Util.getWifiInfo(context);
            if (wifiInfo != null) {
                return wifiInfo.getBSSID();
            }
        }
        catch (Throwable throwable) {
            Util.logWarn(throwable);
        }
        return null;
    }

    public static String getWiFiSSID(Context context) {
        try {
            WifiInfo wifiInfo = Util.getWifiInfo(context);
            if (wifiInfo != null) {
                return wifiInfo.getSSID();
            }
        }
        catch (Throwable throwable) {
            Util.logWarn(throwable);
        }
        return null;
    }

    public static JSONArray getWifiTopN(Context context, int n) {
        try {
            if (Util.checkPermission(context, "android.permission.INTERNET") && Util.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                List list;
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager != null && (list = wifiManager.getScanResults()) != null && list.size() > 0) {
                    Collections.sort(list, new k());
                    JSONArray jSONArray = new JSONArray();
                    for (int i2 = 0; i2 < list.size() && i2 < n; ++i2) {
                        ScanResult scanResult = (ScanResult)list.get(i2);
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put("bs", (Object)scanResult.BSSID);
                        jSONObject.put("ss", (Object)scanResult.SSID);
                        jSONArray.put((Object)jSONObject);
                    }
                    return jSONArray;
                }
            } else {
                Util.logInfo("can not get the permisson of android.permission.INTERNET");
            }
        }
        catch (Throwable throwable) {
            Util.logWarn(throwable);
        }
        return null;
    }

    public static String getRemoteUrlIp(String string) {
        try {
            InetAddress inetAddress;
            URL uRL = new URL(string);
            if (uRL != null && (inetAddress = InetAddress.getByName(uRL.getHost())) != null) {
                return inetAddress.getHostAddress();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static String getSimOperator(Context context) {
        String string = null;
        try {
            if (Util.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager != null) {
                    string = telephonyManager.getSimOperator();
                }
            } else {
                Log.e((String)"MID", (String)"Could not get permission of android.permission.READ_PHONE_STATE");
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MID", (String)"", (Throwable)throwable);
        }
        return string;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static Integer getTelephonyNetworkType(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                return telephonyManager.getNetworkType();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String getExternalStorageInfo(Context context) {
        block4: {
            try {
                if (Util.checkPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                    String string;
                    String string2 = Environment.getExternalStorageState();
                    if (string2 != null && string2.equals("mounted") && (string = Environment.getExternalStorageDirectory().getPath()) != null) {
                        StatFs statFs = new StatFs(string);
                        long l = (long)statFs.getBlockCount() * (long)statFs.getBlockSize() / 1000000L;
                        long l2 = (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize() / 1000000L;
                        return String.valueOf(l2) + "/" + String.valueOf(l);
                    }
                    break block4;
                }
                Log.e((String)"MID", (String)"can not get the permission of android.permission.WRITE_EXTERNAL_STORAGE");
                return null;
            }
            catch (Throwable throwable) {
                Log.e((String)"MID", (String)"", (Throwable)throwable);
            }
        }
        return null;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getApplicationContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static String getLinkedWay(Context context) {
        String string = null;
        try {
            if (Util.checkPermission(context, "android.permission.INTERNET") && Util.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.isConnected()) {
                    String string2 = networkInfo.getTypeName();
                    String string3 = networkInfo.getExtraInfo();
                    if (string2 != null) {
                        string = string2.equalsIgnoreCase("WIFI") ? "WIFI" : (string2.equalsIgnoreCase("MOBILE") ? (string3 != null ? string3 : "MOBILE") : (string3 != null ? string3 : string2));
                    }
                }
            } else {
                Log.e((String)"MID", (String)"can not get the permission of android.permission.ACCESS_WIFI_STATE");
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MID", (String)"", (Throwable)throwable);
        }
        return string;
    }

    public static void updateIfLocalInvalid(Context context, String string) {
        String string2;
        if (Util.isMidValid(string) && !Util.isStringValid(string2 = MidService.getLocalMidOnly(context)) && Util.isStringValid(string)) {
            MidEntity midEntity = new MidEntity();
            midEntity.setImei(Util.getImei(context));
            midEntity.setMac(Util.getWifiMacAddress(context));
            midEntity.setMid(string);
            g.a(context).a(midEntity);
        }
    }
}

