/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat;

import android.content.Context;
import com.tencent.stat.StatConfig;
import com.tencent.stat.common.StatLogger;
import com.tencent.stat.common.k;
import com.tencent.stat.common.p;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashSet;

public class StatNativeCrashReport {
    private static StatLogger b = k.b();
    static StatNativeCrashReport a = new StatNativeCrashReport();
    private volatile boolean c = false;
    public static final String PRE_TAG_TOMBSTONE_FNAME = "tombstone_";
    private static boolean d = false;
    private static boolean e = false;
    private static String f = null;
    private static boolean g = false;

    public native String stringFromJNI();

    public native boolean initJNICrash(String var1);

    public native void enableNativeCrashDebug(boolean var1);

    public native void enableNativeCrash(boolean var1);

    public native String makeJniCrash();

    public static String onNativeCrashHappened() {
        String string = "";
        try {
            new RuntimeException("MTA has caught a native crash, java stack:\n").printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            return runtimeException.toString();
        }
        return string;
    }

    public static void doNativeCrashTest() {
        if (!g) {
            b.warn("libMtaNativeCrash.so not loaded.");
            return;
        }
        a.makeJniCrash();
    }

    public static void setNativeCrashEnable(boolean bl) {
        if (!g) {
            b.warn("libMtaNativeCrash.so not loaded.");
            return;
        }
        try {
            a.enableNativeCrash(bl);
            d = bl;
        }
        catch (Throwable throwable) {
            b.w(throwable);
        }
    }

    public static boolean isNativeCrashEnable() {
        return d;
    }

    public static void setNativeCrashDebugEnable(boolean bl) {
        if (!g) {
            b.warn("libMtaNativeCrash.so not loaded.");
            return;
        }
        try {
            a.enableNativeCrashDebug(bl);
            e = bl;
        }
        catch (Throwable throwable) {
            b.w(throwable);
        }
    }

    public static boolean isNativeCrashDebugEnable() {
        return e;
    }

    public static void initNativeCrash(Context context, String string) {
        if (!g) {
            b.warn("libMtaNativeCrash.so not loaded.");
            return;
        }
        if (StatNativeCrashReport.a.c) {
            return;
        }
        try {
            if (string == null) {
                string = context.getDir("tombstones", 0).getAbsolutePath();
            }
            if (string.length() > 128) {
                b.e("The length of tombstones dir: " + string + " can't exceeds 200 bytes.");
                return;
            }
            f = string;
            p.b(context, "__mta_tombstone__", string);
            StatNativeCrashReport.setNativeCrashEnable(true);
            a.initJNICrash(string);
            StatNativeCrashReport.a.c = true;
            if (StatConfig.isDebugEnable()) {
                b.d("initNativeCrash success.");
            }
        }
        catch (Throwable throwable) {
            b.w(throwable);
        }
    }

    public static String getTombstonesDir(Context context) {
        if (f == null) {
            f = p.a(context, "__mta_tombstone__", "");
        }
        return f;
    }

    static String a(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            b.e(iOException);
        }
        return stringBuilder.toString();
    }

    static LinkedHashSet<File> a(Context context) {
        File[] fileArray;
        File file;
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        String string = StatNativeCrashReport.getTombstonesDir(context);
        if (string != null && (file = new File(string)) != null && file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().startsWith(PRE_TAG_TOMBSTONE_FNAME) || !file2.isFile()) continue;
                if (StatConfig.isDebugEnable()) {
                    b.d("get tombstone file:" + file2.getAbsolutePath().toString());
                }
                linkedHashSet.add(file2.getAbsoluteFile());
            }
        }
        return linkedHashSet;
    }

    static long b(File file) {
        String string = file.getName();
        String string2 = string.replace(PRE_TAG_TOMBSTONE_FNAME, "");
        long l2 = 0L;
        try {
            l2 = Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            b.e(numberFormatException);
        }
        return l2;
    }

    static {
        try {
            System.loadLibrary("MtaNativeCrash");
            g = true;
        }
        catch (Throwable throwable) {
            d = false;
            b.w("can't find libMtaNativeCrash.so, NativeCrash report disable.");
        }
    }
}

